/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.utils;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.gcube.common.database.DatabaseProvider;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.OperationType;
import org.gcube.data.analysis.tabulardata.operation.factories.scopes.ColumnScopedWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.IntegerParameter;
import org.gcube.data.analysis.tabulardata.operation.utils.GuesserWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;

public class GuesserWorkerFactory
extends ColumnScopedWorkerFactory<ResourceCreatorWorker> {
    public static final IntegerParameter CODELISTS_PARAMETER = new IntegerParameter("codelists", "Codelists", "List of codelists", new Cardinality(0, Integer.MAX_VALUE));
    DatabaseProvider configurator;
    CubeManager cubeManager;

    protected OperationType getOperationType() {
        return OperationType.RESOURCECREATOR;
    }

    public Class<ResourceCreatorWorker> getWorkerType() {
        return ResourceCreatorWorker.class;
    }

    @Inject
    public GuesserWorkerFactory(DatabaseProvider configurator, CubeManager cubeManager) {
        this.configurator = configurator;
        this.cubeManager = cubeManager;
    }

    public ResourceCreatorWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        return new GuesserWorker(invocation, this.configurator, this.cubeManager);
    }

    protected OperationId getOperationId() {
        return new OperationId(11002L);
    }

    protected String getOperationName() {
        return "Guesser";
    }

    protected String getOperationDescription() {
        return "Guess all possible relation to external table";
    }

    protected List<Parameter> getParameters() {
        return Collections.singletonList(CODELISTS_PARAMETER);
    }
}

