/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.factories.AnnotationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.CodeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.CodeDescriptionColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.CodeNameColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.exceptions.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.DescriptionsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ImportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.VersionMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.sdmx.WorkerUtils;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXRegistryClientException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXCodelistImporter
extends DataWorker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private static Logger log = LoggerFactory.getLogger(SDMXCodelistImporter.class);
    private OperationInvocation operationInvocation;
    private String url;
    private String agency;
    private String id;
    private String version;
    private Map<String, ColumnLocalId> namesMapping;
    private Map<String, ColumnLocalId> descriptionsMapping;
    private Map<String, ColumnLocalId> annotationsMapping;

    public SDMXCodelistImporter(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, OperationInvocation operationInvocation) {
        super(operationInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.operationInvocation = operationInvocation;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.1f, "Connecting to repository");
        try {
            SDMXRegistryClient registryClient = WorkerUtils.initSDMXClient(this.url);
            this.updateProgress(0.2f, "Getting beans");
            CodelistBean codelist = this.getCodelistBean(registryClient);
            this.updateProgress(0.4f, "Importing data");
            Table table = this.importCodelist(codelist);
            this.updateProgress(0.8f, "Creating resource");
            Table resultTable = this.addImportMetadata(table.getId(), codelist);
            return new ImmutableWorkerResult(resultTable);
        }
        catch (RuntimeException e) {
            log.error("Unable to complete import procedure", (Throwable)e);
            throw new WorkerException("Unable to complete import procedure", (Throwable)e);
        }
    }

    private Table addImportMetadata(TableId tableId, CodelistBean codelist) throws WorkerException {
        try {
            TableMetaCreator tmc = this.cubeManager.modifyTableMeta(tableId);
            tmc.setTableMetadata(new TableMetadata[]{new ImportMetadata("SDMX", this.url, new Date())});
            ArrayList<ImmutableLocalizedText> texts = new ArrayList<ImmutableLocalizedText>();
            for (TextTypeWrapper text : codelist.getNames()) {
                texts.add(new ImmutableLocalizedText(text.getValue(), text.getLocale()));
            }
            NamesMetadata namesMetadata = new NamesMetadata(texts);
            tmc.setTableMetadata(new TableMetadata[]{namesMetadata});
            if (!codelist.getDescriptions().isEmpty()) {
                texts = new ArrayList();
                for (TextTypeWrapper text : codelist.getDescriptions()) {
                    texts.add(new ImmutableLocalizedText(text.getValue(), text.getLocale()));
                }
                DescriptionsMetadata descriptionsMetadata = new DescriptionsMetadata(texts);
                tmc.setTableMetadata(new TableMetadata[]{descriptionsMetadata});
            }
            tmc.setTableMetadata(new TableMetadata[]{new VersionMetadata(codelist.getVersion())});
            return tmc.create();
        }
        catch (Exception e) {
            throw new WorkerException("Unable to modify table metadata.", (Throwable)e);
        }
    }

    private void retrieveParameters() {
        Map parameters = this.operationInvocation.getParameterInstances();
        this.url = (String)parameters.get("registryBaseUrl");
        this.agency = (String)parameters.get("agency");
        this.id = (String)parameters.get("id");
        this.version = (String)parameters.get("version");
    }

    private CodelistBean getCodelistFromBeans(SdmxBeans sdmxBeans, String agencyId, String id, String version) {
        Set codelistBeans = sdmxBeans.getCodelists();
        log.debug("Retrieved codelists: " + codelistBeans);
        if (codelistBeans.size() < 1) {
            throw new RuntimeException(String.format("Unable to find a codelist with the given coordinates: [%s,%s,%s]", agencyId, id, version));
        }
        if (codelistBeans.size() > 1) {
            throw new RuntimeException(String.format("Found too many codelists for the given coordinates: [%s,%s,%s]", agencyId, id, version));
        }
        return (CodelistBean)codelistBeans.iterator().next();
    }

    private CodelistBean getCodelistBean(SDMXRegistryClient registryClient) {
        SdmxBeans sdmxBeans = null;
        try {
            sdmxBeans = registryClient.getCodelist(this.agency, this.id, this.version, SDMXRegistryClient.Detail.full, SDMXRegistryClient.References.none);
            log.debug("Retrieved beans: " + sdmxBeans);
        }
        catch (SDMXRegistryClientException e) {
            String msg = "Error occurred while retrieving codelist.";
            log.error(msg, (Throwable)e);
            throw new RuntimeException(msg);
        }
        CodelistBean codelist = this.getCodelistFromBeans(sdmxBeans, this.agency, this.id, this.version);
        return codelist;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Table importCodelist(CodelistBean codelist) throws WorkerException {
        List codes = codelist.getItems();
        this.checkCodes(codes);
        Table table = this.createBaseTable(codes);
        log.debug("Created table: " + table);
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.connectionProvider.getConnection();
            stmt = conn.createStatement();
            for (CodeBean code : codes) {
                Column relatedColumn;
                ArrayList columnNames = Lists.newArrayList();
                ArrayList columnValues = Lists.newArrayList();
                columnNames.add(((Column)table.getColumnsByType(new Class[]{CodeColumnType.class}).get(0)).getName());
                columnValues.add(code.getId());
                for (TextTypeWrapper codename : code.getNames()) {
                    relatedColumn = table.getColumnById(this.namesMapping.get(codename.getLocale()));
                    columnNames.add(relatedColumn.getName());
                    columnValues.add(codename.getValue().replaceAll("'", "''"));
                }
                for (TextTypeWrapper codeDescription : code.getDescriptions()) {
                    relatedColumn = table.getColumnById(this.descriptionsMapping.get(codeDescription.getLocale()));
                    columnNames.add(relatedColumn.getName());
                    columnValues.add(codeDescription.getValue().replaceAll("'", "''"));
                }
                for (AnnotationBean annotation : code.getAnnotations()) {
                    if (annotation.getTitle() == null || annotation.getText().isEmpty()) continue;
                    relatedColumn = table.getColumnById(this.annotationsMapping.get(annotation.getTitle()));
                    columnNames.add(relatedColumn.getName());
                    columnValues.add(((TextTypeWrapper)annotation.getText().get(0)).getValue().replaceAll("'", "''"));
                }
                StringBuilder sql = this.createSQLStatement(table.getName(), columnNames, columnValues);
                log.trace("Appending SQL query to batch command:\n" + sql.toString());
                stmt.addBatch(sql.toString());
            }
            log.debug("Executing query...");
            stmt.executeBatch();
            rs = stmt.getResultSet();
        }
        catch (SQLException e) {
            try {
                String msg = "Unable to execute database query.";
                log.error(msg, (Throwable)e);
                if (e.getNextException() != null) {
                    log.error("Inner Exception: ", (Throwable)e.getNextException());
                }
                throw new WorkerException(msg, (Throwable)e);
                catch (NoSuchColumnException e2) {
                    throw new WorkerException("Unable to build SQL statement", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly(stmt);
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
        log.debug("Table has been populated");
        return table;
    }

    private Table createBaseTable(List<CodeBean> codes) throws WorkerException {
        Column column;
        TableCreator tc = this.cubeManager.createTable((TableType)new CodelistTableType());
        tc.addColumn(new CodeColumnFactory().createDefault());
        this.namesMapping = new HashMap<String, ColumnLocalId>();
        this.descriptionsMapping = new HashMap<String, ColumnLocalId>();
        this.annotationsMapping = new HashMap<String, ColumnLocalId>();
        ArrayList<String> nameLocales = new ArrayList<String>();
        ArrayList<String> descriptionLocales = new ArrayList<String>();
        ArrayList<String> annotationTitles = new ArrayList<String>();
        this.collectLocalesAndAnnotationTitles(codes, nameLocales, descriptionLocales, annotationTitles);
        log.debug("Collected name locales: " + nameLocales);
        log.debug("Collected description locales: " + descriptionLocales);
        log.debug("Collected annotation titles: " + annotationTitles);
        for (String nameLocale : nameLocales) {
            column = new CodeNameColumnFactory().create(nameLocale);
            tc.addColumn(column);
            if (this.namesMapping.containsKey(nameLocale)) continue;
            this.namesMapping.put(nameLocale, column.getLocalId());
        }
        for (String descriptionLocale : descriptionLocales) {
            column = new CodeDescriptionColumnFactory().create(descriptionLocale);
            tc.addColumn(column);
            if (this.descriptionsMapping.containsKey(descriptionLocale)) continue;
            this.descriptionsMapping.put(descriptionLocale, column.getLocalId());
        }
        for (String annotationTitle : annotationTitles) {
            if (this.annotationsMapping.containsKey(annotationTitle)) continue;
            column = new AnnotationColumnFactory().create((LocalizedText)new ImmutableLocalizedText(annotationTitle), new DataLocaleMetadata("en"));
            tc.addColumn(column);
            this.annotationsMapping.put(annotationTitle, column.getLocalId());
        }
        Table table = null;
        try {
            table = tc.create();
        }
        catch (TableCreationException e) {
            String msg = "Error occurred while trying to create the table.";
            log.error(msg, (Throwable)e);
            throw new WorkerException(msg);
        }
        return table;
    }

    private void collectLocalesAndAnnotationTitles(List<CodeBean> codes, List<String> nameLocales, List<String> descriptionLocales, List<String> annotationTitles) {
        for (CodeBean code : codes) {
            for (TextTypeWrapper textType : code.getNames()) {
                if (textType.getLocale() == null | textType.getLocale().isEmpty() || nameLocales.contains(textType.getLocale())) continue;
                nameLocales.add(textType.getLocale());
            }
            for (TextTypeWrapper textType : code.getDescriptions()) {
                if (textType.getLocale() == null | textType.getLocale().isEmpty() || descriptionLocales.contains(textType.getLocale())) continue;
                descriptionLocales.add(textType.getLocale());
            }
            for (AnnotationBean annotation : code.getAnnotations()) {
                String annotationTitle;
                if (annotation.getTitle() == null | annotation.getTitle().isEmpty() || annotationTitles.contains(annotationTitle = annotation.getTitle())) continue;
                annotationTitles.add(annotationTitle);
            }
        }
    }

    private StringBuilder createSQLStatement(String tableName, List<String> columnNames, List<String> columnValues) {
        StringBuilder sql = new StringBuilder();
        sql.append(String.format("INSERT INTO %s ( ", tableName));
        for (String columnName : columnNames) {
            sql.append(columnName + " , ");
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append(" ) VALUES (");
        for (String columnValue : columnValues) {
            sql.append(String.format(" '%s' , ", columnValue));
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append(");");
        return sql;
    }

    private void checkCodes(List<CodeBean> codes) throws WorkerException {
        if (codes.isEmpty()) {
            throw new WorkerException("Codelist [%s,%s,%s] does not contain codes.");
        }
    }
}

