/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ExportWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.BooleanParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.RegexpStringParameter;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.SDMXDataStructureDefinitionExporter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;

@Singleton
public class SDMXDataStructureDefinitionExporterFactory
extends ExportWorkerFactory {
    private static final OperationId operationId = new OperationId(203L);
    private static final List<Parameter> parameters = new ArrayList<Parameter>();
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;

    @Inject
    public SDMXDataStructureDefinitionExporterFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    private void checkTargetTableEligibility(OperationInvocation invocation) throws InvalidInvocationException {
        Table table = this.cubeManager.getTable(invocation.getTargetTableId());
        if (!table.getTableType().equals((Object)new DatasetTableType())) {
            throw new InvalidInvocationException(invocation, "The table is not a dataset");
        }
        if (table.getColumnsByType(new Class[]{DimensionColumnType.class}).isEmpty()) {
            throw new InvalidInvocationException(invocation, "The table does not have any dimension");
        }
        if (table.getColumnsByType(new Class[]{TimeDimensionColumnType.class}).isEmpty()) {
            throw new InvalidInvocationException(invocation, "The table does not have any time dimension");
        }
    }

    public ResourceCreatorWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkTargetTableEligibility(invocation);
        Table table = this.cubeManager.getTable(invocation.getTargetTableId());
        return new SDMXDataStructureDefinitionExporter(table, this.connectionProvider, invocation, this.cubeManager);
    }

    protected String getOperationName() {
        return "Export Data Structure Definition and Concepts to SDMX registry";
    }

    protected String getOperationDescription() {
        return "Retrieve the Data Structure Deginition and the Concepts among the metadata of the Table and exports them to the remote SDMX registry";
    }

    protected OperationId getOperationId() {
        return operationId;
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    static {
        parameters.add((Parameter)new RegexpStringParameter("registryBaseUrl", "Registry REST URL", "Target SDMX Registry REST Service base URL", Cardinality.ONE, "^https?://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]"));
        parameters.add((Parameter)new RegexpStringParameter("agency", "Agency", "SDMX Agency", Cardinality.ONE, "[A-z0-9_-]+"));
        parameters.add((Parameter)new RegexpStringParameter("id", "Id", "SDMX DSD id", Cardinality.ONE, "[A-z0-9_-]+"));
        parameters.add((Parameter)new RegexpStringParameter("version", "Version", "SDMX Data set version", Cardinality.ONE, "[0-9]+(\\.[0-9]+)?"));
        parameters.add((Parameter)new RegexpStringParameter("obsValueColumn", "Observation Value", "Observation Value column", Cardinality.ONE, "[0-9a-z-]+"));
        parameters.add((Parameter)new BooleanParameter("excel", "Excel Document", "Excel document requested", Cardinality.OPTIONAL));
    }
}

