/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.RegexpStringParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SDMXDataStructureDefinitionExcelExporterFactory {
    private Logger logger;
    private static final OperationId operationId = new OperationId(203L);
    private static final List<Parameter> parameters = new ArrayList<Parameter>();
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;

    @Inject
    public SDMXDataStructureDefinitionExcelExporterFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.logger.debug("Generating DSD Factory");
    }

    private void checkTargetTableEligibility(OperationInvocation invocation) throws InvalidInvocationException {
        Table table = this.cubeManager.getTable(invocation.getTargetTableId());
        if (!table.getTableType().equals((Object)new DatasetTableType())) {
            throw new InvalidInvocationException(invocation, "The table is not a dataset");
        }
        if (table.getColumnsByType(new Class[]{DimensionColumnType.class}).isEmpty()) {
            throw new InvalidInvocationException(invocation, "The table does not have any dimension");
        }
        if (table.getColumnsByType(new Class[]{TimeDimensionColumnType.class}).isEmpty()) {
            throw new InvalidInvocationException(invocation, "The table does not have any time dimension");
        }
    }

    static {
        parameters.add((Parameter)new RegexpStringParameter("agency", "Agency", "SDMX Agency", Cardinality.ONE, "[A-z0-9_-]+"));
        parameters.add((Parameter)new RegexpStringParameter("id", "Id", "SDMX DSD id", Cardinality.ONE, "[A-z0-9_-]+"));
        parameters.add((Parameter)new RegexpStringParameter("version", "Version", "SDMX Data set version", Cardinality.ONE, "[0-9]+(\\.[0-9]+)?"));
        parameters.add((Parameter)new RegexpStringParameter("obsValueColumn", "Observation Value", "Observation Value column", Cardinality.ONE, "[0-9a-z-]+"));
    }
}

