/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.executors;

import org.gcube.data.analysis.tabulardata.model.metadata.common.TableDescriptorMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.sdmx.configuration.ConfigurationManager;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.DataStructureDefinitionWorkerUtils;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.SDMXDataOperationExecutor;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.beans.SDMXDataBean;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.beans.SDMXDataResultBean;
import org.gcube.datapublishing.sdmx.DataInformationProvider;
import org.gcube.datapublishing.sdmx.RegistryInformationProvider;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXRegistryClientException;
import org.gcube.datapublishing.sdmx.impl.exceptions.SDMXVersionException;
import org.gcube.datapublishing.sdmx.security.model.impl.BasicCredentials;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXDataStructurePublisher
implements SDMXDataOperationExecutor {
    private final String OPERATION_NAME = "Publishing";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final String CODELIST_VERSION_ACTION_PROPERTY = "codelist.version.action";
    private boolean primary;

    public SDMXDataStructurePublisher(boolean isPrimary) {
        this.primary = isPrimary;
    }

    @Override
    public String getOperationName() {
        return "Publishing";
    }

    private String getTabularResourceId(Table table) {
        this.log.debug("Getting tabular resource id");
        String response = null;
        try {
            TableDescriptorMetadata metadata = (TableDescriptorMetadata)table.getMetadata(TableDescriptorMetadata.class);
            response = String.valueOf(metadata.getRefId());
            this.log.debug("Tabular resource id " + response);
        }
        catch (RuntimeException e) {
            this.log.error("Unable to get tabular resource id", (Throwable)e);
        }
        return response;
    }

    @Override
    public SDMXDataResultBean executeOperation(SDMXDataBean inputData, OperationInvocation invocation) {
        this.log.debug("Executing SDMX publishing");
        String tabularResourceID = this.getTabularResourceId(inputData.getTableBean().getTable());
        String registryUrl = (String)invocation.getParameterInstances().get("registryBaseUrl");
        BasicCredentials credentials = RegistryInformationProvider.retrieveCredentials((String)registryUrl);
        SDMXRegistryClient registryClient = DataStructureDefinitionWorkerUtils.initSDMXClient(registryUrl, credentials.getUsername(), credentials.getPassword());
        String currentType = null;
        SDMXDataResultBean result = new SDMXDataResultBean();
        try {
            this.log.debug("Publishing associated codelists...");
            currentType = "codelists";
            for (CodelistBean codelist : inputData.getAllCodelists()) {
                try {
                    this.log.debug("Publishing codelist " + codelist.getId());
                    registryClient.publish(codelist);
                    this.log.debug("Codelist published");
                }
                catch (SDMXVersionException e) {
                    switch (this.checkCodelistVersionAction()) {
                        case BLOCK: {
                            this.log.error("Codelist invalid version action: BLOCK. Abort: sending error message");
                            result.setError(this.primary);
                            result.addMessage("Invalid codelist version");
                            result.setException(e);
                            return result;
                        }
                        case WARNING: {
                            this.log.warn("Codelist invalid version action: WARNING. Sending warning message");
                            result.addMessage(e.getMessage());
                        }
                    }
                    this.log.warn(e.getMessage(), (Throwable)e);
                }
            }
            this.log.debug("Operation on codelists completed");
            currentType = "concepts";
            this.log.debug("Publishing concepts...");
            registryClient.publish(inputData.getConcepts().getImmutableInstance());
            this.log.debug("Concepts published");
            currentType = "data structure definitions";
            this.log.debug("Publishing dsd...");
            registryClient.publish(inputData.getDsd().getImmutableInstance());
            this.log.debug("DSD published");
            currentType = "data flow";
            this.log.debug("Publishing data flow...");
            registryClient.publish(inputData.getDataFlow().getImmutableInstance());
            this.log.debug("Data flow published");
            this.log.debug("Updating dataflow-table association on the Information System");
            this.registerIdsOnInformationSystem(result, tabularResourceID, inputData.getTableBean().getTable().getId().getValue(), inputData.getDataFlow().getAgencyId(), inputData.getDataFlow().getId(), inputData.getDataFlow().getVersion());
            this.log.debug("Operation completed");
        }
        catch (SDMXVersionException e) {
            this.log.error("Version error in the pubblication of " + currentType, (Throwable)e);
            result.setError(this.primary);
            result.addMessage("Version error in the pubblication of " + currentType);
            result.setException(e);
        }
        catch (SDMXRegistryClientException e) {
            this.log.error("SDMX Client error in the pubblication of " + currentType, (Throwable)e);
            result.setError(this.primary);
            result.addMessage("SDMX Client error in the pubblication of " + currentType);
            result.setException(e);
        }
        return result;
    }

    private void registerIdsOnInformationSystem(SDMXDataResultBean result, String tabularResourceID, long tableIDLong, String dataFlowAgency, String dataFlowId, String dataFlowVersion) {
        this.log.debug("Registering new dataflow on the Information System");
        String dataFlowkey = DataInformationProvider.getDataFlowKey((String)dataFlowAgency, (String)dataFlowId, (String)dataFlowVersion);
        String tableID = String.valueOf(tableIDLong);
        if (DataInformationProvider.getInstance().addNewAssociation(dataFlowkey, tabularResourceID, tableID)) {
            this.log.debug("Association updated on the Information System");
        } else {
            this.log.error("Unable to update the association");
            result.addMessage("Unable to upload data on the Information System: data source could not be available");
        }
    }

    private CODELIST_ACTIONS checkCodelistVersionAction() {
        String actionParameter = ConfigurationManager.getInstance().getValue("codelist.version.action");
        this.log.debug("Codelist action parameter " + actionParameter);
        if (actionParameter == null || CODELIST_ACTIONS.BLOCK.equals(actionParameter)) {
            return CODELIST_ACTIONS.BLOCK;
        }
        if (CODELIST_ACTIONS.WARNING.equals(actionParameter)) {
            return CODELIST_ACTIONS.WARNING;
        }
        return CODELIST_ACTIONS.IGNORE;
    }

    @Override
    public boolean isPrimaryOperation() {
        return this.primary;
    }

    @Override
    public boolean isDataAware() {
        return false;
    }

    private static enum CODELIST_ACTIONS {
        BLOCK("block"),
        WARNING("warning"),
        IGNORE("ignore");

        private String action;

        private CODELIST_ACTIONS(String action) {
            this.action = action;
        }

        public boolean equals(String actionString) {
            return this.action.equalsIgnoreCase(actionString);
        }

        public String toString() {
            return this.action;
        }
    }
}

