/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.executors;

import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.SDMXDataOperationExecutor;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.beans.SDMXDataBean;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.beans.SDMXDataResultBean;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.ExcelGeneratorFromTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXExcelGenerator
implements SDMXDataOperationExecutor {
    private final String OPERATION_NAME = "Generating Excel";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean primary;

    public SDMXExcelGenerator(boolean primary) {
        this.primary = primary;
    }

    @Override
    public String getOperationName() {
        return "Generating Excel";
    }

    @Override
    public SDMXDataResultBean executeOperation(SDMXDataBean inputData, OperationInvocation invocation) {
        this.logger.debug("Generating excel");
        ExcelGeneratorFromTable generator = new ExcelGeneratorFromTable(inputData.getTableBean());
        boolean result = generator.generateExcel(inputData.getID(), "sdmx");
        this.logger.debug("Operation completed with result " + result);
        SDMXDataResultBean dataResultBean = new SDMXDataResultBean();
        if (!result) {
            dataResultBean.setError(this.primary);
            dataResultBean.addMessage("Unable to save excel");
        }
        return dataResultBean;
    }

    @Override
    public boolean isPrimaryOperation() {
        return this.primary;
    }

    @Override
    public boolean isDataAware() {
        return true;
    }
}

