/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl;

import java.util.ArrayList;
import org.gcube.data.analysis.excel.ColumnModel;
import org.gcube.data.analysis.excel.engine.WorkspaceExcelGenerator;
import org.gcube.data.analysis.excel.engine.impl.WorkspaceExcelGeneratorMetadata;
import org.gcube.data.analysis.excel.metadata.MetadataTable;
import org.gcube.data.analysis.excel.metadata.MetadataTableImpl;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.ExcelGenerator;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.ExcelGeneratorAbstractImpl;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.beans.TemplateBean;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.types.ColumnFactoryMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelGeneratorFromTemplate
extends ExcelGeneratorAbstractImpl
implements ExcelGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private TemplateBean templateBean;

    public ExcelGeneratorFromTemplate(TemplateBean templateBean) {
        this.templateBean = templateBean;
    }

    private MetadataTable generateMetadataTable(String name) {
        this.logger.debug("Generating template columns");
        MetadataTableImpl table = new MetadataTableImpl(name);
        this.logger.debug("Adding primary measure");
        TemplateColumn<?> primaryMeasureColumn = this.templateBean.getPrimaryMeasure();
        ColumnModel primaryColumnModel = ColumnFactoryMetadata.getInstance().createColumn(primaryMeasureColumn, this.templateBean, true);
        table.addColumn(primaryColumnModel);
        this.logger.debug("Getting other columns");
        ArrayList templateColumns = new ArrayList(this.templateBean.getGenericTemplateColumns());
        for (TemplateColumn templateColumn : templateColumns) {
            String columnName = templateColumn.getLabel();
            this.logger.debug("Adding column " + columnName);
            ColumnModel column = ColumnFactoryMetadata.getInstance().createColumn(templateColumn, this.templateBean, false);
            table.addColumn(column);
            this.logger.debug("Column added");
        }
        return table;
    }

    @Override
    protected WorkspaceExcelGenerator getWorkspaceExcelGenerator(String fileName, String folderName) {
        this.logger.debug("Workspace generator for data tables");
        return new WorkspaceExcelGeneratorMetadata(this.generateMetadataTable(fileName), fileName, folderName);
    }
}

