/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl;

import org.gcube.data.analysis.excel.engine.WorkspaceExcelGenerator;
import org.gcube.data.analysis.excel.engine.exceptions.ExcelNotSavedException;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.ExcelGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ExcelGeneratorAbstractImpl
implements ExcelGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    protected abstract WorkspaceExcelGenerator getWorkspaceExcelGenerator(String var1, String var2);

    @Override
    public boolean generateExcel(String fileName, String folderName) {
        this.logger.debug("Generating excel on the workspace");
        this.logger.debug("Token retrieved");
        if (!fileName.endsWith("xls") && !fileName.endsWith("xlsx")) {
            fileName = fileName + ".xlsx";
        }
        this.logger.debug("Saving file " + fileName + " in the folder " + folderName);
        WorkspaceExcelGenerator excelGenerator = this.getWorkspaceExcelGenerator(fileName, folderName);
        this.logger.debug("Generating file..");
        excelGenerator.generate();
        this.logger.debug("File generated");
        try {
            this.logger.debug("Saving file..");
            excelGenerator.save();
            this.logger.debug("File saved");
            return true;
        }
        catch (ExcelNotSavedException e) {
            this.logger.warn("Excel file not saved", (Throwable)e);
            return false;
        }
    }
}

