/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl;

import java.util.ArrayList;
import org.gcube.data.analysis.excel.data.DataColumn;
import org.gcube.data.analysis.excel.data.DataTable;
import org.gcube.data.analysis.excel.data.DataTableImpl;
import org.gcube.data.analysis.excel.engine.WorkspaceExcelGenerator;
import org.gcube.data.analysis.excel.engine.impl.WorkspaceExcelGeneratorData;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.ExcelGenerator;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.ExcelGeneratorAbstractImpl;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.beans.ColumnBean;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.beans.DataColumnBean;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.beans.TableBean;
import org.gcube.data.analysis.tabulardata.operation.sdmx.excel.impl.types.ColumnFactoryData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelGeneratorFromTable
extends ExcelGeneratorAbstractImpl
implements ExcelGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private TableBean tableBean;
    private String locale;
    private static final String DEFAULT_LOCALE = "en";

    public ExcelGeneratorFromTable(TableBean tableBean, String locale) {
        if (locale == null) {
            this.locale = DEFAULT_LOCALE;
        }
        this.tableBean = tableBean;
    }

    public ExcelGeneratorFromTable(TableBean tableBean) {
        this(tableBean, DEFAULT_LOCALE);
    }

    private DataTable generateDataTable() {
        String tableName = this.tableBean.getTableName();
        this.logger.debug("Table name " + tableName);
        DataColumnBean primaryMeasure = this.tableBean.getPrimaryMeasure();
        DataTableImpl dataTable = new DataTableImpl(tableName);
        DataColumn primaryMeasureDataColumn = ColumnFactoryData.getInstance().createColumn(primaryMeasure, this.tableBean, this.locale);
        dataTable.addColumn(primaryMeasureDataColumn);
        ArrayList<DataColumnBean> columnBeans = new ArrayList<DataColumnBean>(this.tableBean.getAttributeColumns());
        columnBeans.add(this.tableBean.getTimeDimensionColumn());
        columnBeans.addAll(this.tableBean.getDimensionColumns());
        columnBeans.addAll(this.tableBean.getMeasureColumns());
        for (ColumnBean columnBean : columnBeans) {
            this.logger.debug("Loading column " + columnBean.getName(this.locale));
            DataColumn dataColumn = ColumnFactoryData.getInstance().createColumn((DataColumnBean)columnBean, this.tableBean, this.locale);
            dataTable.addColumn(dataColumn);
            this.logger.debug("Column added");
        }
        return dataTable;
    }

    @Override
    protected WorkspaceExcelGenerator getWorkspaceExcelGenerator(String fileName, String folderName) {
        this.logger.debug("Workspace generator for data tables");
        return new WorkspaceExcelGeneratorData(this.generateDataTable(), fileName, folderName);
    }
}

