/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.codelist;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.TableDescriptorMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.sdmxsource.sdmx.api.model.mutable.base.AnnotationMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.ItemMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.codelist.CodelistMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.AnnotationMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.TextTypeWrapperMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.codelist.CodeMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.codelist.CodelistMutableBeanImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDMXCodelistGenerator {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Table table;
    private DatabaseConnectionProvider connectionProvider;
    private Column codeColumn;
    private List<Column> nameColumns;
    private List<Column> descriptionColumns;
    private List<Column> annotationColumns;
    private String targetAgency;
    private String targetId;
    private String targetVersion;

    public SDMXCodelistGenerator(Table table, DatabaseConnectionProvider connectionProvider, String targetAgency, String targetId, String targetVersion) {
        this.table = table;
        this.connectionProvider = connectionProvider;
        this.targetAgency = targetAgency;
        this.targetId = targetId;
        this.targetVersion = targetVersion;
        this.log.debug("Agency ID = " + targetAgency);
        this.log.debug("ID = " + targetId);
        this.log.debug("Version = " + targetVersion);
    }

    private void retrieveNeededColumns() {
        this.codeColumn = (Column)this.table.getColumnsByType(new Class[]{CodeColumnType.class}).get(0);
        this.nameColumns = this.table.getColumnsByType(new Class[]{CodeNameColumnType.class});
        this.descriptionColumns = this.table.getColumnsByType(new Class[]{CodeDescriptionColumnType.class});
        this.annotationColumns = this.table.getColumnsByType(new Class[]{AnnotationColumnType.class});
    }

    public void populateCodelistWithCodes(CodelistMutableBean codelist) throws SQLException {
        this.retrieveNeededColumns();
        String query = this.buildSqlQuery(this.codeColumn, this.nameColumns, this.descriptionColumns, this.annotationColumns);
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.connectionProvider.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String columnDataLocale;
                boolean validCode = false;
                CodeMutableBeanImpl code = new CodeMutableBeanImpl();
                String id = rs.getString(this.codeColumn.getName());
                for (Column column : this.nameColumns) {
                    try {
                        columnDataLocale = ((DataLocaleMetadata)column.getMetadata(DataLocaleMetadata.class)).getLocale();
                        String name = rs.getString(column.getName());
                        if (name != null && name.trim().length() > 0) {
                            code.addName(columnDataLocale, name);
                            validCode = true;
                            continue;
                        }
                        this.log.warn("Invalid column " + id + ", name not found");
                    }
                    catch (NoSuchMetadataException e) {
                        this.log.warn("Invalid column " + id);
                    }
                }
                if (validCode) {
                    code.setId(id);
                    for (Column column : this.descriptionColumns) {
                        try {
                            columnDataLocale = ((DataLocaleMetadata)column.getMetadata(DataLocaleMetadata.class)).getLocale();
                            code.addDescription(columnDataLocale, rs.getString(column.getName()));
                        }
                        catch (NoSuchMetadataException columnDataLocale2) {}
                    }
                    for (Column column : this.annotationColumns) {
                        try {
                            AnnotationMutableBeanImpl annotation = new AnnotationMutableBeanImpl();
                            LocalizedText text = ((NamesMetadata)column.getMetadata(NamesMetadata.class)).getTextWithLocale("en");
                            annotation.setTitle(text.getValue());
                            ArrayList annotationValues = Lists.newArrayList();
                            annotationValues.add(new TextTypeWrapperMutableBeanImpl(text.getLocale(), rs.getString(column.getName())));
                            annotation.setText((List)annotationValues);
                            code.addAnnotation((AnnotationMutableBean)annotation);
                        }
                        catch (NoSuchMetadataException noSuchMetadataException) {}
                    }
                    codelist.addItem((ItemMutableBean)code);
                }
                this.log.debug(codelist.getItems().size() + " codes");
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Unable to execute database query.";
                this.log.error(msg, (Throwable)e);
                if (e.getNextException() != null) {
                    this.log.error("Inner Exception: ", (Throwable)e.getNextException());
                }
                throw e;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly(stmt);
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
    }

    public CodelistMutableBean createBaseCodelistBean() {
        CodelistMutableBeanImpl codelist = new CodelistMutableBeanImpl();
        codelist.setAgencyId(this.targetAgency);
        codelist.setVersion(this.targetVersion);
        codelist.setId(this.targetId);
        try {
            ArrayList names = Lists.newArrayList();
            for (LocalizedText text : ((NamesMetadata)this.table.getMetadata(NamesMetadata.class)).getTexts()) {
                String locale = text.getLocale();
                String value = text.getValue();
                this.log.debug("Locale = " + locale);
                this.log.debug("Value " + value);
                names.add(new TextTypeWrapperMutableBeanImpl(locale, value));
            }
            codelist.setNames((List)names);
            this.log.debug("Names set");
        }
        catch (NoSuchMetadataException e) {
            this.log.warn("Names Metadata not found in the table");
            this.setTableDescriptionMetadata((CodelistMutableBean)codelist);
        }
        ArrayList codelistAnnotations = Lists.newArrayList();
        AnnotationMutableBeanImpl sourceAnnotation = new AnnotationMutableBeanImpl();
        sourceAnnotation.setTitle("Source");
        ArrayList textList = Lists.newArrayList();
        textList.add(new TextTypeWrapperMutableBeanImpl("en", "Tabular Data"));
        sourceAnnotation.setText((List)textList);
        codelistAnnotations.add(sourceAnnotation);
        codelist.setAnnotations((List)codelistAnnotations);
        return codelist;
    }

    private void setTableDescriptionMetadata(CodelistMutableBean codeList) {
        this.log.warn("Setting table description parameters");
        TableDescriptorMetadata tableDescriptionMetadata = (TableDescriptorMetadata)this.table.getMetadata(TableDescriptorMetadata.class);
        String name = tableDescriptionMetadata.getName();
        codeList.addName("en", name);
    }

    private String buildSqlQuery(Column codeColumn, List<Column> nameColumns, List<Column> descriptionColumns, List<Column> annotationColumns) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT " + codeColumn.getName() + ", ");
        for (Column column : nameColumns) {
            sql.append(column.getName() + " , ");
        }
        for (Column column : descriptionColumns) {
            sql.append(column.getName() + " , ");
        }
        for (Column column : annotationColumns) {
            sql.append(column.getName() + " , ");
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append(" FROM " + this.table.getName() + ";");
        this.log.debug("SQL " + sql.toString());
        return sql.toString();
    }
}

