/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ExportWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.BooleanParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.RegexpStringParameter;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.SDMXDataOperationManagerBuilder;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.executors.SDMXDataStructurePublisher;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.executors.SDMXExcelGenerator;
import org.gcube.data.analysis.tabulardata.operation.sdmx.datastructuredefinition.resource.SDMXDataStructureDefinitionPublisherResourceBuilder;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SDMXDataStructureDefinitionExporterFactory
extends ExportWorkerFactory {
    private Logger logger;
    private static final OperationId operationId = new OperationId(203L);
    private static final List<Parameter> parameters = new ArrayList<Parameter>();
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;

    @Inject
    public SDMXDataStructureDefinitionExporterFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.logger.debug("Generating DSD Factory");
    }

    private void checkTargetTableEligibility(OperationInvocation invocation) throws InvalidInvocationException {
        Table table = this.cubeManager.getTable(invocation.getTargetTableId());
        if (!table.getTableType().equals((Object)new DatasetTableType())) {
            throw new InvalidInvocationException(invocation, "The table is not a dataset");
        }
        if (table.getColumnsByType(new Class[]{DimensionColumnType.class}).isEmpty()) {
            throw new InvalidInvocationException(invocation, "The table does not have any dimension");
        }
        if (table.getColumnsByType(new Class[]{TimeDimensionColumnType.class}).isEmpty()) {
            throw new InvalidInvocationException(invocation, "The table does not have any time dimension");
        }
    }

    public ResourceCreatorWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.logger.debug("Generating the worker");
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkTargetTableEligibility(invocation);
        this.logger.debug("Check completed");
        Table table = this.cubeManager.getTable(invocation.getTargetTableId());
        this.logger.debug("Table generated");
        Boolean excelObject = (Boolean)invocation.getParameterInstances().get("excel");
        this.logger.debug("Excel requested " + excelObject);
        SDMXDataOperationManagerBuilder dataOperationManagerBuilder = new SDMXDataOperationManagerBuilder();
        dataOperationManagerBuilder.setTable(table);
        dataOperationManagerBuilder.setConnectionProvider(this.connectionProvider);
        dataOperationManagerBuilder.setInvocation(invocation);
        dataOperationManagerBuilder.setCubeManager(this.cubeManager);
        dataOperationManagerBuilder.setResourceBuilder(new SDMXDataStructureDefinitionPublisherResourceBuilder());
        dataOperationManagerBuilder.addExecutor(new SDMXDataStructurePublisher(true));
        if (excelObject != null && excelObject.booleanValue()) {
            dataOperationManagerBuilder.addExecutor(new SDMXExcelGenerator(false));
        }
        return dataOperationManagerBuilder.build();
    }

    protected String getOperationName() {
        this.logger.debug("Get operation name");
        return "Export Data Structure Definition and Concepts to SDMX registry";
    }

    protected String getOperationDescription() {
        this.logger.debug("Get operation description");
        return "Retrieve the Data Structure Deginition and the Concepts among the metadata of the Table and exports them to the remote SDMX registry";
    }

    protected OperationId getOperationId() {
        this.logger.debug("Get operation id");
        return operationId;
    }

    protected List<Parameter> getParameters() {
        this.logger.debug("Get operation parameters");
        return parameters;
    }

    static {
        parameters.add((Parameter)new RegexpStringParameter("registryBaseUrl", "Registry REST URL", "Target SDMX Registry REST Service base URL", Cardinality.ONE, "^https?://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]"));
        parameters.add((Parameter)new RegexpStringParameter("agency", "Agency", "SDMX Agency", Cardinality.ONE, "[A-z0-9_-]+"));
        parameters.add((Parameter)new RegexpStringParameter("id", "Id", "SDMX DSD id", Cardinality.ONE, "[A-z0-9_-]+"));
        parameters.add((Parameter)new RegexpStringParameter("version", "Version", "SDMX Data set version", Cardinality.ONE, "[0-9]+(\\.[0-9]+)?"));
        parameters.add((Parameter)new RegexpStringParameter("obsValueColumn", "Observation Value", "Observation Value column", Cardinality.ONE, "[0-9a-z-]+"));
        parameters.add((Parameter)new BooleanParameter("excel", "Excel Document", "Excel document requested", Cardinality.OPTIONAL));
    }
}

