package org.gcube.data.analysis.tabulardata.statistical;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDSL;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.csv.importer.CSVImportFactory;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ImportWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.SimpleStringParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;


@Singleton
public class ImportFromStatisticalOperationFactory extends ImportWorkerFactory{

	
	private static OperationId OPERATION_ID = new OperationId(10003);

	private static List<Parameter> parameters = new ArrayList<Parameter>();
	
	public static final SimpleStringParameter RESOURCE_ID=new SimpleStringParameter("resourceId", "Resource id", "The table id inside the dataspace", Cardinality.ONE);

	static{
		parameters.add(RESOURCE_ID);
	}
	
	private CubeManager cubeManager;	
	private CSVImportFactory csvImportFactory;
	
	@Inject
	public ImportFromStatisticalOperationFactory(CubeManager cubeManager,
			CSVImportFactory csvImportFactory) {
		super();
		this.cubeManager = cubeManager;
		this.csvImportFactory = csvImportFactory;
	}
	
	@Override
	public Worker createWorker(OperationInvocation invocation)
			throws InvalidInvocationException {
		performBaseChecks(invocation,cubeManager);
		StatisticalManagerDataSpace dataSpace =null;
		try{
			dataSpace = StatisticalManagerDSL.dataSpace().build();
		}catch (Exception e){
			throw new InvalidInvocationException(invocation,"Unable to contact statistical manager service",e);
		}
		IClient client=new StorageClient("StatisticalOperations", "StatisticalOperations", "service", AccessType.SHARED).getClient();
		return new ImportFromStatisticalOperation(invocation, cubeManager, dataSpace, csvImportFactory, client);
	}
	
	@Override
	protected String getOperationName() {
		return "Import from Statistical";
	}

	@Override
	protected String getOperationDescription() {
		return "Import the selected resource as CSV generic table.";
	}

	@Override
	protected List<Parameter> getParameters() {
		return parameters;
	}
	
	@Override
	protected OperationId getOperationId() {
		return OPERATION_ID;
	}
	
}
