/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.table.ExportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.csv.exporter.CSVExportFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.statistical.StatisticalOperationFactory;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;

public class ExportToStatisticalOperation
extends Worker {
    private CSVExportFactory csvExportFactory;
    private CubeManager cubeManager;
    private StatisticalManagerDataSpace statisticalDataSpace;
    private Table targetTable;
    private Table exportedTable;
    private String dataSpaceTableId;
    private String user;

    public ExportToStatisticalOperation(OperationInvocation sourceInvocation, CSVExportFactory csvExportFactory, CubeManager cubeManager, StatisticalManagerDataSpace statisticalDataSpace) {
        super(sourceInvocation);
        this.csvExportFactory = csvExportFactory;
        this.cubeManager = cubeManager;
        this.statisticalDataSpace = statisticalDataSpace;
    }

    protected WorkerResult execute() throws WorkerException {
        this.loadParameters();
        this.updateProgress(0.1f);
        this.exportCSV();
        this.updateProgress(0.5f);
        this.importIntoDataSpace();
        this.updateProgress(0.9f);
        return new ImmutableWorkerResult(this.exportedTable);
    }

    private void loadParameters() {
        Map params = this.getSourceInvocation().getParameterInstances();
        this.user = (String)params.get(StatisticalOperationFactory.USER.getIdentifier());
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
    }

    private void exportCSV() throws WorkerException {
        HashMap<String, Object> exportParams = new HashMap<String, Object>();
        ArrayList<String> columns = new ArrayList<String>();
        for (Column col : this.targetTable.getColumnsByType(new Class[]{IdColumnType.class, ValidationColumnType.class})) {
            columns.add(col.getName());
        }
        exportParams.put("columns", columns);
        exportParams.put("encoding", Charset.defaultCharset().toString());
        exportParams.put("separator", ",");
        WorkerWrapper wrapper = new WorkerWrapper((WorkerFactory)this.csvExportFactory);
        try {
            WorkerStatus status = wrapper.execute(this.targetTable.getId(), null, exportParams);
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new WorkerException("Failed export to CSV, worker status was " + status);
            }
            WorkerResult result = wrapper.getResult();
            this.exportedTable = result.getResultTable();
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to export table as CSV", (Throwable)e);
        }
    }

    private void importIntoDataSpace() throws WorkerException {
        String template = "GENERIC";
        TableTemplates tableTemplate = null;
        for (TableTemplates t : TableTemplates.values()) {
            if (!template.contentEquals(t.toString())) continue;
            tableTemplate = t;
            break;
        }
        boolean hasHeader = true;
        String delimiter = ",";
        try {
            File f = new File(((ExportMetadata)this.exportedTable.getMetadata(ExportMetadata.class)).getUri());
            this.dataSpaceTableId = this.statisticalDataSpace.createTableFromCSV(f, hasHeader, delimiter, "", "TDM - " + this.exportedTable.getName(), tableTemplate, "Exported from TDM", this.user);
            this.exportedTable = this.cubeManager.modifyTableMeta(this.exportedTable.getId()).setTableMetadata(new TableMetadata[]{new ExportMetadata("Statistical dataspace", this.dataSpaceTableId, new Date(System.currentTimeMillis()))}).create();
        }
        catch (NoSuchMetadataException e) {
            throw new WorkerException("Unable to locate exported CSV file", (Throwable)e);
        }
    }
}

