/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.UUID;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.data.analysis.statisticalmanager.exception.ResourceNotFoundException;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.csv.importer.CSVImportFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.statistical.ImportFromStatisticalOperationFactory;

public class ImportFromStatisticalOperation
extends DataWorker {
    private StatisticalManagerDataSpace statisticalDataSpace;
    private CSVImportFactory csvImportFactory;
    private IClient storageClient;
    private String resourceId;
    private Table importedTable;
    private File csvFile;

    public ImportFromStatisticalOperation(OperationInvocation sourceInvocation, StatisticalManagerDataSpace statisticalDataSpace, CSVImportFactory csvImportFactory, IClient storageClient) {
        super(sourceInvocation);
        this.statisticalDataSpace = statisticalDataSpace;
        this.csvImportFactory = csvImportFactory;
        this.storageClient = storageClient;
    }

    protected WorkerResult execute() throws WorkerException {
        this.resourceId = (String)this.getSourceInvocation().getParameterInstances().get(ImportFromStatisticalOperationFactory.RESOURCE_ID.getIdentifier());
        this.updateProgress(0.1f, "Transfering data");
        this.importSMTable();
        this.updateProgress(0.5f, "Parsing data");
        this.importedTable = this.importCSV(this.csvFile);
        this.updateProgress(0.9f, "Finalizing");
        return new ImmutableWorkerResult(this.importedTable);
    }

    private void importSMTable() throws WorkerException {
        try {
            this.csvFile = this.statisticalDataSpace.exportTable(this.resourceId);
        }
        catch (ResourceNotFoundException e) {
            throw new WorkerException("Unable to import result table from dataspace ", (Throwable)e);
        }
    }

    private Table importCSV(File csv) throws WorkerException {
        Character delimiter = Character.valueOf(',');
        Boolean hasHeader = true;
        String fileUri = this.sendToStorage(csv);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("hasHeader", hasHeader);
        parameters.put("url", fileUri);
        parameters.put("separator", delimiter + "");
        parameters.put("encoding", Charset.defaultCharset().toString());
        WorkerWrapper wrapper = new WorkerWrapper((WorkerFactory)this.csvImportFactory);
        try {
            WorkerStatus status = wrapper.execute(null, null, parameters);
            if (status.equals((Object)WorkerStatus.SUCCEDED)) {
                return ((WorkerResult)wrapper.getResult()).getResultTable();
            }
            throw new WorkerException("Failed to import file from Statistical Manager");
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to import SM Table from File " + csv.getAbsolutePath(), (Throwable)e);
        }
    }

    private String sendToStorage(File csv) {
        String rPath = "/csv/" + UUID.randomUUID().toString();
        this.storageClient.put(true).LFile(csv.getAbsolutePath()).RFile(rPath);
        return this.storageClient.getUrl().RFile(rPath);
    }
}

