/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.util.HashMap;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;

public class Common {
    public static boolean isValidColumnName(Column col) {
        String currentLabel = OperationHelper.retrieveColumnLabel((Column)col);
        return Common.isValidString(currentLabel);
    }

    public static boolean isValidString(String str) {
        return str.matches("^[a-z][a-z_0-9]*");
    }

    public static String fixColumnName(String columnName) {
        return columnName.replaceAll("\\W", "_").toLowerCase();
    }

    public static String fixColumnName(Column col) {
        return Common.fixColumnName(OperationHelper.retrieveColumnLabel((Column)col));
    }

    public static Map<ColumnLocalId, String> curateLabels(Table table) {
        HashMap<ColumnLocalId, String> toReturn = new HashMap<ColumnLocalId, String>();
        HashMap<String, Integer> clashCounter = new HashMap<String, Integer>();
        for (Column col : table.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class})) {
            String originalLabel = OperationHelper.retrieveColumnLabel((Column)col);
            String fixed = Common.fixColumnName(originalLabel);
            if (clashCounter.containsKey(fixed)) {
                clashCounter.put(fixed, (Integer)clashCounter.get(fixed) + 1);
                fixed = fixed + "_" + clashCounter.get(fixed);
            } else {
                clashCounter.put(fixed, 1);
            }
            toReturn.put(col.getLocalId(), fixed);
        }
        return toReturn;
    }
}

