/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.csv4j.ParseException;
import net.sf.csv4j.ProcessingException;
import org.apache.commons.io.IOUtils;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPURLConnection;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMComputationConfig;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMResourceType;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMAbstractResource;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMComputation;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMEntries;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMFile;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMInputEntry;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMObject;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMOperationInfo;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMResource;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMTable;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GcubeServiceReferenceMetadata;
import org.gcube.data.analysis.tabulardata.model.resources.InternalURI;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.resources.TableResource;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.export.Utils;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableTableResource;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableURIResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.data.analysis.tabulardata.statistical.Common;
import org.gcube.data.analysis.tabulardata.statistical.Constants;
import org.gcube.data.analysis.tabulardata.statistical.ExportToStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.ImportFromStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.StatisticalOperationFactory;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticalOperation
extends ResourceCreatorWorker {
    private static Logger logger = LoggerFactory.getLogger(StatisticalOperation.class);
    private StatisticalManagerFactory statisticalManagerFactory;
    private StatisticalManagerDataSpace dataSpace;
    private ExportToStatisticalOperationFactory exportFactory;
    private ImportFromStatisticalOperationFactory importFactory;
    private Home home;
    private CubeManager cubeManager;
    private Map<String, Object> algorithmParameters;
    private String user;
    private String algorithmId;
    private String experimentTitle = null;
    private String experimentDescription = null;
    private Table targetTable;
    private String dataSpaceTableId;
    private boolean clearDataspace = false;
    private boolean removeExported = false;
    private Map<String, String> toSerializeValues = new HashMap<String, String>();
    private List<ResourceDescriptorResult> results = new ArrayList<ResourceDescriptorResult>();
    String computationId;

    public StatisticalOperation(OperationInvocation sourceInvocation, StatisticalManagerFactory statisticalManagerFactory, ExportToStatisticalOperationFactory exportFactory, ImportFromStatisticalOperationFactory importFactory, Home home, CubeManager cubeManager) {
        super(sourceInvocation);
        this.statisticalManagerFactory = statisticalManagerFactory;
        this.exportFactory = exportFactory;
        this.importFactory = importFactory;
        this.cubeManager = cubeManager;
        this.home = home;
    }

    protected ResourcesResult execute() throws WorkerException, OperationAbortedException {
        try {
            this.getParameters();
            this.updateProgress(0.05f, "Checking if already exported to dataspace..");
            this.dataSpaceTableId = this.getSMTable();
            this.checkAborted();
            this.updateProgress(0.2f, "Submitting computation");
            this.submitComputation();
            this.checkAborted();
            this.updateProgress(0.4f, "Waiting computation");
            this.waitForComputation();
            this.checkAborted();
            this.updateProgress(0.6f, "Importing results");
            this.generateTableFromResult();
            if (this.removeExported) {
                this.updateProgress(0.8f, "Cleaning up");
                this.deleteExternalReference();
            }
            this.updateProgress(0.9f, "Finalizing");
            if (this.results.size() == 0) {
                throw new WorkerException("No resources were successfully imported from SM");
            }
            return new ResourcesResult(this.results);
        }
        catch (WorkerException e) {
            throw e;
        }
        catch (OperationAbortedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WorkerException("Unexpected internal error. Please contact support", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void serializeResultMap() {
        if (this.toSerializeValues.isEmpty()) return;
        PrintWriter writer = null;
        try {
            File serialized = File.createTempFile("result", ".txt");
            writer = new PrintWriter(serialized);
            for (Map.Entry<String, String> entry : this.toSerializeValues.entrySet()) {
                writer.println(entry.getKey() + " : " + entry.getValue());
            }
            IOUtils.closeQuietly((Writer)writer);
            IClient client = Utils.getStorageClient();
            String remotePath = "/SM_Integration/" + serialized.getName();
            client.put(true).LFile(serialized.getAbsolutePath()).RFile(remotePath);
            String id = client.put(true).LFile(serialized.getAbsolutePath()).RFile(remotePath);
            this.results.add((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(id), "text/plain"), "General results", "Text file containig etherogeneus results", ResourceType.GENERIC_FILE));
            if (writer == null) return;
        }
        catch (Exception e) {
            try {
                logger.warn("Unable to write results to file ", (Throwable)e);
                if (writer == null) return;
            }
            catch (Throwable throwable) {
                if (writer == null) throw throwable;
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
            return;
        }
        IOUtils.closeQuietly((Writer)writer);
        return;
    }

    public void getParameters() {
        Map params = this.getSourceInvocation().getParameterInstances();
        this.algorithmParameters = (Map)params.get(StatisticalOperationFactory.SM_ENTRIES.getIdentifier());
        this.user = (String)params.get(StatisticalOperationFactory.USER.getIdentifier());
        this.algorithmId = (String)params.get(StatisticalOperationFactory.ALGORITHM.getIdentifier());
        if (params.containsKey(StatisticalOperationFactory.TITLE.getIdentifier())) {
            this.experimentTitle = (String)params.get(StatisticalOperationFactory.TITLE.getIdentifier());
        }
        if (params.containsKey(StatisticalOperationFactory.DESCRIPTION.getIdentifier())) {
            this.experimentDescription = (String)params.get(StatisticalOperationFactory.DESCRIPTION.getIdentifier());
        }
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        try {
            this.clearDataspace = (Boolean)OperationHelper.getParameter((LeafParameter)StatisticalOperationFactory.CLEAR_DATASPACE, (OperationInvocation)this.getSourceInvocation());
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            this.removeExported = (Boolean)OperationHelper.getParameter((LeafParameter)StatisticalOperationFactory.REMOVE_EXPORTED, (OperationInvocation)this.getSourceInvocation());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void submitComputation() throws ParseException, IOException, ProcessingException {
        SMComputationRequest request = new SMComputationRequest();
        SMComputationConfig config = new SMComputationConfig();
        Table toUseTable = this.targetTable;
        if (toUseTable.contains(DatasetViewTableMetadata.class)) {
            DatasetViewTableMetadata dsMeta = (DatasetViewTableMetadata)toUseTable.getMetadata(DatasetViewTableMetadata.class);
            toUseTable = this.cubeManager.getTable(dsMeta.getTargetDatasetViewTableId());
        }
        Map<ColumnLocalId, String> curatedColumnLabels = Common.curateLabels(toUseTable, new String[0]);
        ArrayList<SMInputEntry> entryList = new ArrayList<SMInputEntry>();
        for (Map.Entry<String, Object> mapEntry : this.algorithmParameters.entrySet()) {
            String paramValue = (String)mapEntry.getValue();
            if (paramValue.equals(toUseTable.getId().toString())) {
                entryList.add(new SMInputEntry(mapEntry.getKey(), this.dataSpaceTableId));
                continue;
            }
            for (Map.Entry<ColumnLocalId, String> curatedEntry : curatedColumnLabels.entrySet()) {
                paramValue = paramValue.replaceAll(curatedEntry.getKey().getValue(), curatedEntry.getValue());
            }
            entryList.add(new SMInputEntry(mapEntry.getKey(), paramValue));
        }
        config.parameters(new SMEntries(entryList.toArray(new SMInputEntry[entryList.size()])));
        config.algorithm(this.algorithmId);
        request.user(this.user);
        request.title(this.experimentTitle == null ? this.algorithmId : this.experimentTitle);
        request.description(this.experimentDescription == null ? "Submission via TDM" : this.experimentDescription);
        request.config(config);
        this.computationId = this.statisticalManagerFactory.executeComputation(request);
    }

    public void waitForComputation() throws WorkerException, OperationAbortedException {
        boolean complete = false;
        block6: while (!complete) {
            this.checkAborted();
            SMComputation computation = this.statisticalManagerFactory.getComputation(this.computationId);
            SMOperationStatus status = SMOperationStatus.values()[computation.operationStatus()];
            switch (status) {
                case FAILED: {
                    throw new WorkerException("Failed Experiment.");
                }
                case COMPLETED: {
                    complete = true;
                    continue block6;
                }
            }
            SMOperationInfo infos = this.statisticalManagerFactory.getComputationInfo(this.computationId, this.user);
            float smPercent = Float.parseFloat(infos.percentage()) / 100.0f;
            this.updateProgress(0.1f + smPercent * 0.8f, "Waiting for computation to complete");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {}
        }
    }

    private void generateTableFromResult() throws WorkerException {
        SMComputation computation = this.statisticalManagerFactory.getComputation(this.computationId);
        SMAbstractResource abstractResource = computation.abstractResource();
        SMResource smResource = abstractResource.resource();
        this.handleSMResource(smResource);
        this.serializeResultMap();
    }

    private Table importFromTableSpace(SMTable table) throws WorkerException, OperationAbortedException {
        WorkerWrapper wrapper = this.createWorkerWrapper((WorkerFactory)this.importFactory);
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(ImportFromStatisticalOperationFactory.RESOURCE_ID.getIdentifier(), table.resourceId());
            params.put(ImportFromStatisticalOperationFactory.RESOURCE_NAME.getIdentifier(), table.name());
            params.put(ImportFromStatisticalOperationFactory.DELETE_REMOTE_RESOURCE.getIdentifier(), this.clearDataspace);
            WorkerStatus status = wrapper.execute(null, null, params);
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new WorkerException("Failed export to dataspace");
            }
            return ((WorkerResult)wrapper.getResult()).getResultTable();
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to import table from dataspace.", (Throwable)e);
        }
    }

    private void handleSMResource(SMResource toHandle) throws WorkerException {
        try {
            int resourceTypeIndex = toHandle.resourceType();
            SMResourceType smResType = SMResourceType.values()[resourceTypeIndex];
            switch (smResType) {
                case FILE: {
                    SMFile smFile = (SMFile)toHandle;
                    MyFile f = Utils.getStorageClient().getMetaFile().RFile(smFile.url());
                    this.results.add((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(f.getId())), smFile.description(), "-", ResourceType.GENERIC_FILE));
                    break;
                }
                case TABULAR: {
                    Table table = this.importFromTableSpace((SMTable)toHandle);
                    this.results.add((ResourceDescriptorResult)new ImmutableTableResource(new TableResource(table.getId()), OperationHelper.retrieveTableLabel((Table)table), "Imported from SM", ResourceType.GENERIC_TABLE));
                    break;
                }
                case OBJECT: {
                    SMObject objRes = (SMObject)toHandle;
                    if (objRes.name().contentEquals(PrimitiveTypes.MAP.toString())) {
                        for (Map.Entry<String, SMResource> entry : StatisticalOperation.asMap(objRes).entrySet()) {
                            this.handleSMResource(entry.getValue());
                        }
                        break;
                    }
                    if (objRes.name().contentEquals(PrimitiveTypes.FILE.toString())) {
                        MyFile file = Utils.getStorageClient().getMetaFile().RFile(objRes.url());
                        this.results.add((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(file.getId())), objRes.description(), "-", ResourceType.GENERIC_FILE));
                        break;
                    }
                    if (objRes.name().contentEquals(PrimitiveTypes.IMAGES.toString())) {
                        this.results.addAll(this.getFilesUrlFromFolderUrl(objRes.url()));
                        break;
                    }
                    this.toSerializeValues.put(String.format("%s [%s]", objRes.description(), objRes.name()), objRes.url());
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unable to get resource " + toHandle, (Throwable)e);
        }
    }

    private static Map<String, SMResource> asMap(SMObject theMap) throws Exception {
        logger.debug("the url for map object is " + theMap.url());
        Object obj = null;
        try (InputStream is = null;){
            Map smMap;
            is = StatisticalOperation.getStorageClientInputStream(theMap.url());
            XStream xstream = new XStream();
            xstream.alias("org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMObject", SMObject.class);
            xstream.alias("org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMFile", SMFile.class);
            xstream.alias("org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMResource", SMResource.class);
            xstream.alias("org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTable", SMTable.class);
            obj = xstream.fromXML(is);
            Map map = smMap = (Map)obj;
            return map;
        }
    }

    private List<ResourceDescriptorResult> getFilesUrlFromFolderUrl(String url) throws WorkerException {
        try {
            ArrayList<ResourceDescriptorResult> toReturn = new ArrayList<ResourceDescriptorResult>();
            String callerScope = ScopeProvider.instance.get();
            ScopeBean scope = new ScopeBean(callerScope);
            while (!scope.is(ScopeBean.Type.INFRASTRUCTURE)) {
                scope = scope.enclosingScope();
            }
            ScopeProvider.instance.set(scope.toString());
            String HLServiceName = null;
            String HLPackage = "org.gcube.portlets.user";
            String HLResourceName = "HomeLibraryRepository";
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Category/text() eq 'Database' and $resource/Profile/Name eq '" + HLResourceName + "' ");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            for (ServiceEndpoint.AccessPoint ap : ((ServiceEndpoint)client.submit((Query)query).get(0)).profile().accessPoints()) {
                if (!ap.name().equals("ServiceName")) continue;
                HLServiceName = ap.address();
                break;
            }
            IClient storage = new StorageClient(HLPackage, HLServiceName, this.user, AccessType.SHARED, scope.toString(), true).getClient();
            Workspace ws = this.home.getWorkspace();
            WorkspaceItem folderItem = ws.getItemByPath(url);
            WorkspaceFolder folder = (WorkspaceFolder)folderItem;
            List childrenList = folder.getChildren();
            for (WorkspaceItem item : childrenList) {
                ExternalImage file = (ExternalImage)item;
                String name = item.getName();
                String mimeType = file.getMimeType();
                MyFile storageFile = storage.getMetaFile().RFile(file.getRemotePath());
                toReturn.add((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(storageFile.getId()), mimeType), name, item.getDescription(), ResourceType.GENERIC_FILE));
            }
            ScopeProvider.instance.set(callerScope);
            return toReturn;
        }
        catch (Exception e) {
            throw new WorkerException("Unable to retrieve results from workspace ", (Throwable)e);
        }
    }

    private static InputStream getStorageClientInputStream(String url) throws Exception {
        URL u = new URL(null, url, new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                return new SMPURLConnection(u);
            }
        });
        return u.openConnection().getInputStream();
    }

    private String getSMTable() throws WorkerException, OperationAbortedException {
        try {
            GcubeServiceReferenceMetadata meta = (GcubeServiceReferenceMetadata)this.targetTable.getMetadata(GcubeServiceReferenceMetadata.class);
            if (meta.getServiceClass().equals(Constants.STATISTICAL_SERIVCE_CLASS) && meta.getServiceName().equals(Constants.STATISTICAL_SERVICE_NAME)) {
                return meta.getExternalId();
            }
            throw new NoSuchMetadataException(GcubeServiceReferenceMetadata.class);
        }
        catch (NoSuchMetadataException e) {
            this.updateProgress(0.1f, "Transferring to dataspace");
            return this.importIntoDataSpace().getExternalId();
        }
    }

    private GcubeServiceReferenceMetadata importIntoDataSpace() throws WorkerException, OperationAbortedException {
        WorkerWrapper wrapper = this.createWorkerWrapper((WorkerFactory)this.exportFactory);
        try {
            WorkerStatus status = wrapper.execute(this.targetTable.getId(), null, this.getSourceInvocation().getParameterInstances());
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new WorkerException("Failed export to dataspace");
            }
            return (GcubeServiceReferenceMetadata)this.cubeManager.getTable(this.targetTable.getId()).getMetadata(GcubeServiceReferenceMetadata.class);
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to export table to dataspace.", (Throwable)e);
        }
        catch (NoSuchMetadataException e) {
            throw new WorkerException("Unable to get dataspace table id for exported table", (Throwable)e);
        }
    }

    private void deleteExternalReference() {
        Common.getSMDataSpace().removeTable(this.dataSpaceTableId);
        this.cubeManager.modifyTableMeta(this.targetTable.getId()).removeTableMetadata(GcubeServiceReferenceMetadata.class).create();
    }
}

