/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.csv4j.ParseException;
import net.sf.csv4j.ProcessingException;
import org.apache.commons.io.IOUtils;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMComputationConfig;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMAbstractResource;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMComputation;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMEntries;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMInputEntry;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMOperationInfo;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMResource;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GcubeServiceReferenceMetadata;
import org.gcube.data.analysis.tabulardata.model.resources.InternalURI;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.export.Utils;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableURIResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.data.analysis.tabulardata.statistical.Common;
import org.gcube.data.analysis.tabulardata.statistical.Constants;
import org.gcube.data.analysis.tabulardata.statistical.ExportToStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.ImportFromStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.StatisticalOperationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticalOperation
extends ResourceCreatorWorker {
    private static Logger logger = LoggerFactory.getLogger(StatisticalOperation.class);
    private StatisticalManagerFactory statisticalManagerFactory;
    private StatisticalManagerDataSpace dataSpace;
    private ExportToStatisticalOperationFactory exportFactory;
    private ImportFromStatisticalOperationFactory importFactory;
    private Home home;
    private CubeManager cubeManager;
    private Map<String, Object> algorithmParameters;
    private String user;
    private String algorithmId;
    private String experimentTitle = null;
    private String experimentDescription = null;
    private Table targetTable;
    private String dataSpaceTableId;
    private boolean clearDataspace = false;
    private boolean removeExported = false;
    private Map<String, String> toSerializeValues = new HashMap<String, String>();
    private List<ResourceDescriptorResult> results = new ArrayList<ResourceDescriptorResult>();
    String computationId;

    public StatisticalOperation(OperationInvocation sourceInvocation, StatisticalManagerFactory statisticalManagerFactory, ExportToStatisticalOperationFactory exportFactory, ImportFromStatisticalOperationFactory importFactory, Home home, CubeManager cubeManager) {
        super(sourceInvocation);
        this.statisticalManagerFactory = statisticalManagerFactory;
        this.exportFactory = exportFactory;
        this.importFactory = importFactory;
        this.cubeManager = cubeManager;
        this.home = home;
    }

    protected ResourcesResult execute() throws WorkerException, OperationAbortedException {
        try {
            this.getParameters();
            this.updateProgress(0.05f, "Checking if already exported to dataspace..");
            this.dataSpaceTableId = this.getSMTable();
            this.checkAborted();
            this.updateProgress(0.2f, "Submitting computation");
            this.submitComputation();
            this.checkAborted();
            this.updateProgress(0.4f, "Waiting computation");
            this.waitForComputation();
            this.checkAborted();
            this.updateProgress(0.6f, "Importing results");
            this.generateTableFromResult();
            if (this.removeExported) {
                this.updateProgress(0.8f, "Cleaning up");
                this.deleteExternalReference();
            }
            this.updateProgress(0.9f, "Finalizing");
            if (this.results.size() == 0) {
                throw new WorkerException("No resources were successfully imported from SM");
            }
            return new ResourcesResult(this.results);
        }
        catch (WorkerException e) {
            throw e;
        }
        catch (OperationAbortedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WorkerException("Unexpected internal error. Please contact support", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void serializeResultMap() {
        if (this.toSerializeValues.isEmpty()) return;
        PrintWriter writer = null;
        try {
            File serialized = File.createTempFile("result", ".txt");
            writer = new PrintWriter(serialized);
            for (Map.Entry<String, String> entry : this.toSerializeValues.entrySet()) {
                writer.println(entry.getKey() + " : " + entry.getValue());
            }
            IOUtils.closeQuietly((Writer)writer);
            IClient client = Utils.getStorageClient();
            String remotePath = "/SM_Integration/" + serialized.getName();
            client.put(true).LFile(serialized.getAbsolutePath()).RFile(remotePath);
            String id = client.put(true).LFile(serialized.getAbsolutePath()).RFile(remotePath);
            this.results.add((ResourceDescriptorResult)new ImmutableURIResult(new InternalURI(new URI(id), "text/plain"), (this.experimentTitle == null ? this.algorithmId : this.experimentTitle) + " General results", "Text file containig etherogeneus results", ResourceType.GENERIC_FILE));
            if (writer == null) return;
        }
        catch (Exception e) {
            try {
                logger.warn("Unable to write results to file ", (Throwable)e);
                if (writer == null) return;
            }
            catch (Throwable throwable) {
                if (writer == null) throw throwable;
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
            return;
        }
        IOUtils.closeQuietly((Writer)writer);
        return;
    }

    public void getParameters() {
        Map params = this.getSourceInvocation().getParameterInstances();
        this.algorithmParameters = (Map)params.get(StatisticalOperationFactory.SM_ENTRIES.getIdentifier());
        this.user = (String)params.get(StatisticalOperationFactory.USER.getIdentifier());
        this.algorithmId = (String)params.get(StatisticalOperationFactory.ALGORITHM.getIdentifier());
        if (params.containsKey(StatisticalOperationFactory.TITLE.getIdentifier())) {
            this.experimentTitle = (String)params.get(StatisticalOperationFactory.TITLE.getIdentifier());
        }
        if (params.containsKey(StatisticalOperationFactory.DESCRIPTION.getIdentifier())) {
            this.experimentDescription = (String)params.get(StatisticalOperationFactory.DESCRIPTION.getIdentifier());
        }
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        try {
            this.clearDataspace = (Boolean)OperationHelper.getParameter((LeafParameter)StatisticalOperationFactory.CLEAR_DATASPACE, (OperationInvocation)this.getSourceInvocation());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.removeExported = (Boolean)OperationHelper.getParameter((LeafParameter)StatisticalOperationFactory.REMOVE_EXPORTED, (OperationInvocation)this.getSourceInvocation());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void submitComputation() throws ParseException, IOException, ProcessingException {
        SMComputationRequest request = new SMComputationRequest();
        SMComputationConfig config = new SMComputationConfig();
        Table toUseTable = this.targetTable;
        if (toUseTable.contains(DatasetViewTableMetadata.class)) {
            DatasetViewTableMetadata dsMeta = (DatasetViewTableMetadata)toUseTable.getMetadata(DatasetViewTableMetadata.class);
            toUseTable = this.cubeManager.getTable(dsMeta.getTargetDatasetViewTableId());
        }
        Map<ColumnLocalId, String> curatedColumnLabels = Common.curateLabels(toUseTable, new String[0]);
        ArrayList<SMInputEntry> entryList = new ArrayList<SMInputEntry>();
        for (Map.Entry<String, Object> mapEntry : this.algorithmParameters.entrySet()) {
            String paramValue = (String)mapEntry.getValue();
            if (paramValue.equals(toUseTable.getId().toString())) {
                entryList.add(new SMInputEntry(mapEntry.getKey(), this.dataSpaceTableId));
                continue;
            }
            for (Map.Entry<ColumnLocalId, String> curatedEntry : curatedColumnLabels.entrySet()) {
                paramValue = paramValue.replaceAll(curatedEntry.getKey().getValue(), curatedEntry.getValue());
            }
            entryList.add(new SMInputEntry(mapEntry.getKey(), paramValue));
        }
        config.parameters(new SMEntries(entryList.toArray(new SMInputEntry[entryList.size()])));
        config.algorithm(this.algorithmId);
        request.user(this.user);
        request.title(this.experimentTitle == null ? this.algorithmId : this.experimentTitle);
        request.description(this.experimentDescription == null ? "Submission via TDM" : this.experimentDescription);
        request.config(config);
        this.computationId = this.statisticalManagerFactory.executeComputation(request);
    }

    public void waitForComputation() throws WorkerException, OperationAbortedException {
        boolean complete = false;
        block6: while (!complete) {
            this.checkAborted();
            SMComputation computation = this.statisticalManagerFactory.getComputation(this.computationId);
            SMOperationStatus status = SMOperationStatus.values()[computation.operationStatus()];
            switch (status) {
                case FAILED: {
                    throw new WorkerException("Failed Experiment.");
                }
                case COMPLETED: {
                    complete = true;
                    continue block6;
                }
            }
            SMOperationInfo infos = this.statisticalManagerFactory.getComputationInfo(this.computationId, this.user);
            float smPercent = Float.parseFloat(infos.percentage()) / 100.0f;
            this.updateProgress(0.1f + smPercent * 0.8f, "Waiting for computation to complete");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void generateTableFromResult() throws WorkerException {
        SMComputation computation = this.statisticalManagerFactory.getComputation(this.computationId);
        SMAbstractResource abstractResource = computation.abstractResource();
        SMResource smResource = abstractResource.resource();
        Common.handleSMResource(smResource, this.results, this.toSerializeValues, (WorkerWrapper<DataWorker, WorkerResult>)this.createWorkerWrapper((WorkerFactory)this.importFactory), this.clearDataspace, this.user, this.home);
        this.serializeResultMap();
    }

    private String getSMTable() throws WorkerException, OperationAbortedException {
        try {
            GcubeServiceReferenceMetadata meta = (GcubeServiceReferenceMetadata)this.targetTable.getMetadata(GcubeServiceReferenceMetadata.class);
            if (meta.getServiceClass().equals(Constants.STATISTICAL_SERIVCE_CLASS) && meta.getServiceName().equals(Constants.STATISTICAL_SERVICE_NAME)) {
                return meta.getExternalId();
            }
            throw new NoSuchMetadataException(GcubeServiceReferenceMetadata.class);
        }
        catch (NoSuchMetadataException e) {
            this.updateProgress(0.1f, "Transferring to dataspace");
            return this.importIntoDataSpace().getExternalId();
        }
    }

    private GcubeServiceReferenceMetadata importIntoDataSpace() throws WorkerException, OperationAbortedException {
        WorkerWrapper wrapper = this.createWorkerWrapper((WorkerFactory)this.exportFactory);
        try {
            WorkerStatus status = wrapper.execute(this.targetTable.getId(), null, this.getSourceInvocation().getParameterInstances());
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new WorkerException("Failed export to dataspace");
            }
            return (GcubeServiceReferenceMetadata)this.cubeManager.getTable(this.targetTable.getId()).getMetadata(GcubeServiceReferenceMetadata.class);
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to export table to dataspace.", (Throwable)e);
        }
        catch (NoSuchMetadataException e) {
            throw new WorkerException("Unable to get dataspace table id for exported table", (Throwable)e);
        }
    }

    private void deleteExternalReference() {
        Common.getSMDataSpace().removeTable(this.dataSpaceTableId);
        this.cubeManager.modifyTableMeta(this.targetTable.getId()).removeTableMetadata(GcubeServiceReferenceMetadata.class).create();
    }
}

