/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.csv4j.ParseException;
import net.sf.csv4j.ProcessingException;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.statisticalmanager.stubs.types.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.stubs.types.schema.SMImport;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GcubeServiceReferenceMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.resources.StringResource;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.export.Utils;
import org.gcube.data.analysis.tabulardata.operation.export.csv.exporter.CSVExportFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableStringResource;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableURIResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.data.analysis.tabulardata.statistical.Common;
import org.gcube.data.analysis.tabulardata.statistical.Constants;
import org.gcube.data.analysis.tabulardata.statistical.ExportToStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.StatisticalOperationFactory;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;

public class ExportToStatisticalOperation
extends ResourceCreatorWorker {
    private CSVExportFactory csvExportFactory;
    private CubeManager cubeManager;
    private StatisticalManagerDataSpace statisticalDataSpace;
    private Table targetTable;
    private Set<String> toEscapeFieldNames = new HashSet<String>();
    private ImmutableURIResult exportedTable;
    private String dataSpaceTableId;
    private String user;

    public ExportToStatisticalOperation(OperationInvocation sourceInvocation, CSVExportFactory csvExportFactory, CubeManager cubeManager, StatisticalManagerDataSpace statisticalDataSpace) {
        super(sourceInvocation);
        this.csvExportFactory = csvExportFactory;
        this.cubeManager = cubeManager;
        this.statisticalDataSpace = statisticalDataSpace;
    }

    public ResourcesResult execute() throws WorkerException, OperationAbortedException {
        try {
            this.loadParameters();
            this.updateProgress(0.1f, "Creating csv");
            this.exportCSV();
            this.updateProgress(0.5f, "Saving to user's SM dataspace");
            this.importIntoDataSpace();
            this.updateProgress(0.9f, "Finalizing");
            TableMetaCreator tmc = this.cubeManager.modifyTableMeta(this.getSourceInvocation().getTargetTableId());
            tmc.setTableMetadata(new TableMetadata[]{new GcubeServiceReferenceMetadata(Constants.STATISTICAL_SERIVCE_CLASS, Constants.STATISTICAL_SERVICE_NAME, new Date(), this.dataSpaceTableId)});
            tmc.create();
            return new ResourcesResult((ResourceDescriptorResult)new ImmutableStringResource(new StringResource(Constants.STATISTICAL_URI_PREFIX + ":" + this.dataSpaceTableId), OperationHelper.retrieveTableLabel((Table)this.targetTable), "Statistical dataspace CSV version", ResourceType.CSV));
        }
        catch (WorkerException e) {
            throw e;
        }
        catch (OperationAbortedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WorkerException("Unexpected internal error. Please contact support", (Throwable)e);
        }
    }

    private void loadParameters() {
        Map params = this.getSourceInvocation().getParameterInstances();
        this.user = (String)params.get(StatisticalOperationFactory.USER.getIdentifier());
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        if (params.containsKey(ExportToStatisticalOperationFactory.toEscapeFieldNamesParam.getIdentifier())) {
            Object paramValue = OperationHelper.getParameter((LeafParameter)ExportToStatisticalOperationFactory.toEscapeFieldNamesParam, (OperationInvocation)this.getSourceInvocation());
            if (paramValue instanceof Iterable) {
                for (String s : (Iterable)paramValue) {
                    this.toEscapeFieldNames.add(s);
                }
            } else {
                this.toEscapeFieldNames.add((String)paramValue);
            }
        }
    }

    private void exportCSV() throws WorkerException, OperationAbortedException, ParseException, IOException, ProcessingException {
        HashMap<String, Object> exportParams = new HashMap<String, Object>();
        ArrayList<String> columns = new ArrayList<String>();
        HashMap<ColumnLocalId, String> toRestoreLabels = new HashMap<ColumnLocalId, String>();
        if (this.targetTable.contains(DatasetViewTableMetadata.class)) {
            DatasetViewTableMetadata dsMeta = (DatasetViewTableMetadata)this.targetTable.getMetadata(DatasetViewTableMetadata.class);
            this.targetTable = this.cubeManager.getTable(dsMeta.getTargetDatasetViewTableId());
        }
        TableMetaCreator tmc = this.cubeManager.modifyTableMeta(this.targetTable.getId());
        Map<ColumnLocalId, String> curatedLabels = Common.curateLabels(this.targetTable, this.toEscapeFieldNames.toArray(new String[this.toEscapeFieldNames.size()]));
        boolean changedMeta = false;
        for (Map.Entry<ColumnLocalId, String> entry : curatedLabels.entrySet()) {
            columns.add(entry.getKey().getValue());
            String originalLabel = OperationHelper.retrieveColumnLabel((Column)this.targetTable.getColumnById(entry.getKey()));
            if (originalLabel.equals(entry.getValue())) continue;
            toRestoreLabels.put(entry.getKey(), originalLabel);
            tmc.setColumnMetadata(entry.getKey(), new ColumnMetadata[]{new NamesMetadata(Collections.singletonList(new ImmutableLocalizedText(entry.getValue())))});
            changedMeta = true;
        }
        if (changedMeta) {
            tmc.create();
        }
        exportParams.put("columns", columns);
        exportParams.put("encoding", Charset.defaultCharset().toString());
        exportParams.put("separator", ",");
        exportParams.put("useView", new Boolean(false));
        WorkerWrapper wrapper = this.createWorkerWrapper((WorkerFactory)this.csvExportFactory);
        try {
            WorkerStatus status = wrapper.execute(this.targetTable.getId(), null, exportParams);
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new WorkerException("Failed export to CSV, worker status was " + status);
            }
            this.exportedTable = (ImmutableURIResult)((ResourcesResult)wrapper.getResult()).getResources().get(0);
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to export table as CSV", (Throwable)e);
        }
        if (changedMeta) {
            for (Map.Entry entry : toRestoreLabels.entrySet()) {
                tmc.setColumnMetadata((ColumnLocalId)entry.getKey(), new ColumnMetadata[]{new NamesMetadata(Collections.singletonList(new ImmutableLocalizedText((String)entry.getValue())))});
            }
            tmc.create();
        }
    }

    private void importIntoDataSpace() throws WorkerException {
        String template = "GENERIC";
        TableTemplates tableTemplate = null;
        for (TableTemplates t : TableTemplates.values()) {
            if (!template.contentEquals(t.toString())) continue;
            tableTemplate = t;
            break;
        }
        boolean hasHeader = true;
        String delimiter = ",";
        File f = null;
        try {
            f = this.getInputFile();
            String importID = this.statisticalDataSpace.createTableFromCSV(f, hasHeader, delimiter, "#", "TDM - " + OperationHelper.retrieveTableLabel((Table)this.targetTable), tableTemplate, "Exported from TDM", this.user);
            boolean complete = false;
            block14: while (!complete) {
                SMImport smImport = this.statisticalDataSpace.getImporter(importID);
                SMOperationStatus status = SMOperationStatus.values()[smImport.operationStatus()];
                switch (status) {
                    case FAILED: {
                        throw new WorkerException("Unable to send table to data space");
                    }
                    case COMPLETED: {
                        complete = true;
                        this.dataSpaceTableId = smImport.abstractResource().resource().resourceId();
                        continue block14;
                    }
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (WorkerException e) {
            throw e;
        }
        catch (NoSuchMetadataException e) {
            throw new WorkerException("Unable to locate exported CSV file", (Throwable)e);
        }
        catch (Exception e) {
            throw new WorkerException("Unable to locate exported CSV file", (Throwable)e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    private File getInputFile() throws Exception {
        File tempFile = File.createTempFile("import", ".csv");
        Utils.getStorageClient().get().LFile(tempFile.getAbsolutePath()).RFile(this.exportedTable.getResource().getStringValue());
        return tempFile;
    }
}

