/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.importer.csv.CSVImportFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.statistical.ImportFromStatisticalOperationFactory;

public class ImportFromStatisticalOperation
extends DataWorker {
    private SClient dmClient;
    private CSVImportFactory csvImportFactory;
    private IClient storageClient;
    private CubeManager cubeManager;
    private String resourceId;
    private Table importedTable;
    private boolean delete = false;

    public ImportFromStatisticalOperation(CubeManager cubeManager, OperationInvocation sourceInvocation, SClient dmClient, CSVImportFactory csvImportFactory, IClient storageClient) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.dmClient = dmClient;
        this.csvImportFactory = csvImportFactory;
        this.storageClient = storageClient;
    }

    protected WorkerResult execute() throws WorkerException, OperationAbortedException {
        this.resourceId = (String)OperationHelper.getParameter((LeafParameter)ImportFromStatisticalOperationFactory.RESOURCE_ID, (OperationInvocation)this.getSourceInvocation());
        try {
            this.delete = (Boolean)OperationHelper.getParameter((LeafParameter)ImportFromStatisticalOperationFactory.DELETE_REMOTE_RESOURCE, (OperationInvocation)this.getSourceInvocation());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.updateProgress(0.1f, "Transfering data");
        this.checkAborted();
        this.updateProgress(0.5f, "Parsing data");
        this.importedTable = this.importCSV(this.resourceId);
        this.checkAborted();
        this.updateProgress(0.9f, "Finalizing");
        String toApplyLabel = "SM Table " + this.resourceId;
        if (this.getSourceInvocation().getParameterInstances().containsKey(ImportFromStatisticalOperationFactory.RESOURCE_NAME.getIdentifier())) {
            toApplyLabel = (String)OperationHelper.getParameter((LeafParameter)ImportFromStatisticalOperationFactory.RESOURCE_NAME, (OperationInvocation)this.getSourceInvocation());
        }
        TableMetaCreator tmc = this.cubeManager.modifyTableMeta(this.importedTable.getId());
        tmc.setTableMetadata(new TableMetadata[]{new NamesMetadata(Collections.singletonList(new ImmutableLocalizedText(toApplyLabel)))});
        this.importedTable = tmc.create();
        this.checkAborted();
        if (this.delete) {
            this.removeSMTable();
        }
        return new ImmutableWorkerResult(this.importedTable);
    }

    private void removeSMTable() {
        throw new RuntimeException("HOWWW");
    }

    private Table importCSV(String fileUri) throws WorkerException, OperationAbortedException {
        Character delimiter = Character.valueOf(',');
        Boolean hasHeader = true;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("hasHeader", hasHeader);
        parameters.put("url", fileUri);
        parameters.put("separator", delimiter + "");
        parameters.put("encoding", Charset.defaultCharset().toString());
        WorkerWrapper wrapper = this.createWorkerWrapper((WorkerFactory)this.csvImportFactory);
        try {
            WorkerStatus status = wrapper.execute(null, null, parameters);
            if (status.equals((Object)WorkerStatus.SUCCEDED)) {
                return ((WorkerResult)wrapper.getResult()).getResultTable();
            }
            throw new WorkerException("Failed to import file from Statistical Manager");
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to import SM Table from File " + fileUri, (Throwable)e);
        }
    }
}

