/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.test;

import java.util.Observable;
import java.util.Observer;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.EmptyType;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.junit.Assert;

public class WorkerChecker<T extends Worker<?>> {
    T worker;
    CubeManager cubeManager;
    boolean checkFallback = true;

    public boolean isCheckFallback() {
        return this.checkFallback;
    }

    public void setCheckFallback(boolean checkFallback) {
        this.checkFallback = checkFallback;
    }

    public WorkerChecker(CubeManager cubeManager, T worker) {
        this.cubeManager = cubeManager;
        this.worker = worker;
    }

    private void displayResult() {
        if (this.worker.getResult() instanceof EmptyType) {
            System.err.println("Result:\n" + this.cubeManager.getTable(this.worker.getSourceInvocation().getTargetTableId()));
        } else {
            System.err.println("Result:\n" + this.worker.getResult());
        }
    }

    private void displayException() {
        this.worker.getException().printStackTrace(System.err);
    }

    private void displayStatus() {
        System.err.println(String.format("Status: %s %s%%", this.worker.getStatus(), Math.ceil(this.worker.getProgress() * 100.0f)));
    }

    public void check() {
        TableId tableId = this.worker.getSourceInvocation().getTargetTableId();
        if (tableId != null) {
            System.err.println("Target table before operation:\n" + this.cubeManager.getTable(tableId));
        }
        WorkerObserver workerObserver = new WorkerObserver();
        this.worker.addObserver((Observer)workerObserver);
        Thread runnerThread = new Thread((Runnable)this.worker);
        runnerThread.start();
        try {
            runnerThread.join();
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Error detected: " + e.getMessage()));
        }
    }

    public class WorkerObserver
    implements Observer {
        @Override
        public void update(Observable o, Object arg) {
            Worker worker = (Worker)o;
            WorkerChecker.this.displayStatus();
            switch (worker.getStatus()) {
                case INITIALIZING: {
                    this.checkNullResult(worker);
                    break;
                }
                case IN_PROGRESS: {
                    this.checkNullResult(worker);
                    if (worker.getException() == null) break;
                    throw new IllegalStateException(String.format("Exception must be null when status is %s", worker.getStatus()));
                }
                case SUCCEDED: {
                    WorkerChecker.this.displayResult();
                    if (worker.getResult() == null) {
                        throw new IllegalStateException(String.format("Result table cannot be null while status is %s", worker.getStatus()));
                    }
                    return;
                }
                case FAILED: {
                    WorkerChecker.this.displayException();
                    if (worker.getException() == null) {
                        throw new IllegalStateException(String.format("Exception must be different than null when status is %s", worker.getStatus()));
                    }
                    Assert.fail((String)String.format("Failed Execution, error is %s", worker.getException()));
                    return;
                }
            }
        }

        private void checkNullResult(Worker<?> worker) {
            if (worker.getResult() != null) {
                throw new IllegalStateException(String.format("Result must be null when status is %s", worker.getStatus()));
            }
        }
    }
}

