/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.test;

import java.util.Map;
import javax.inject.Inject;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationScope;
import org.gcube.data.analysis.tabulardata.operation.invocation.InvocationCreator;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.test.FactoryChecker;
import org.gcube.data.analysis.tabulardata.operation.test.WorkerChecker;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidityResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.remover.ResourceRemoverProvider;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.RollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class OperationTester<T extends WorkerFactory<?>> {
    FactoryChecker factoryChecker;
    WorkerChecker<?> workerChecker;
    WorkerChecker<RollbackWorker> rollbackWorkerChecker;
    @Inject
    private CubeManager cubeManager;

    @Before
    public void setupFactoryChecker() {
        this.factoryChecker = new FactoryChecker(this.getFactory());
    }

    protected abstract WorkerFactory<?> getFactory();

    @BeforeClass
    public static void beforeClass() {
        ScopeProvider.instance.set("/gcube/devsec");
    }

    private OperationInvocation createOperationInvocation() {
        OperationDescriptor descriptor = this.getFactory().getOperationDescriptor();
        InvocationCreator creator = InvocationCreator.getCreator((OperationDescriptor)descriptor);
        creator.setParameters(this.getParameterInstances());
        OperationScope scope = descriptor.getScope();
        if (scope == OperationScope.TABLE || scope == OperationScope.COLUMN) {
            creator.setTargetTable(this.getTargetTableId());
        }
        if (scope == OperationScope.COLUMN) {
            creator.setTargetColumn(this.getTargetColumnId());
        }
        return creator.create();
    }

    @Test
    public final void testFactory() {
        this.factoryChecker.check();
    }

    protected abstract Map<String, Object> getParameterInstances();

    @Test
    public final void testInvocationDescription() throws InvalidInvocationException {
        OperationInvocation invocation = this.createOperationInvocation();
        System.out.println(this.getFactory().describeInvocation(invocation));
    }

    @Test
    public final void testWorker() throws InvalidInvocationException {
        OperationInvocation invocation = this.createOperationInvocation();
        this.workerChecker = new WorkerChecker<Worker>(this.cubeManager, this.getFactory().createWorker(invocation));
        if (!this.getFactory().getPrecoditionValidations().isEmpty()) {
            for (WorkerFactory vw : this.getFactory().getPrecoditionValidations()) {
                WorkerChecker<Worker> preconditionChecker = new WorkerChecker<Worker>(this.cubeManager, vw.createWorker(invocation));
                preconditionChecker.check();
                Assert.assertTrue((boolean)((ValidityResult)((ValidationWorker)preconditionChecker.worker).getResult()).isValid());
            }
        }
        this.workerChecker.check();
        if (this.workerChecker.worker.getStatus() == WorkerStatus.FAILED) {
            this.workerChecker.worker.getException().printStackTrace();
        }
        Assert.assertEquals((Object)WorkerStatus.SUCCEDED, (Object)this.workerChecker.worker.getStatus());
        if (this.getFactory().getWorkerType().equals(DataWorker.class) && this.getFactory().isRollbackable()) {
            DataWorker dataWorker = (DataWorker)this.workerChecker.worker;
            this.rollbackWorkerChecker = new WorkerChecker<RollbackWorker>(this.cubeManager, this.getFactory().createRollbackWoker(((WorkerResult)dataWorker.getResult()).getDiffTable(), ((WorkerResult)dataWorker.getResult()).getResultTable(), invocation));
            this.rollbackWorkerChecker.check();
            Assert.assertTrue((boolean)((WorkerResult)((RollbackWorker)this.rollbackWorkerChecker.worker).getResult()).getResultTable().sameStructureAs(this.cubeManager.getTable(invocation.getTargetTableId())));
        } else if (this.getFactory() instanceof ResourceRemoverProvider) {
            try {
                for (ResourceDescriptorResult descr : ((ResourcesResult)this.workerChecker.worker.getResult()).getResources()) {
                    ((ResourceRemoverProvider)this.getFactory()).getResourceRemover().onRemove(descr.getResource());
                }
                System.out.println("resource cleaned");
            }
            catch (Exception e) {
                System.err.println("Error deleting resource " + e.getMessage());
            }
        }
    }

    protected boolean checkFallback() {
        return true;
    }

    protected abstract ColumnLocalId getTargetColumnId();

    protected abstract TableId getTargetTableId();

    static {
        Handler.activateProtocol();
    }
}

