package org.gcube.data.analysis.tabulardata.service.tabular;

import java.util.Calendar;
import java.util.List;

import org.gcube.data.analysis.tabulardata.metadata.MetadataHolder;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.TabularResourceMetadata;

public interface TabularResource extends MetadataHolder<TabularResourceMetadata> {
	
	public TabularResourceId getId();
	
	public Calendar getCreationDate();
	
	public String getTableType();
	
	public boolean isValid();
	
	public List<HistoryStep> getHistory();
	
	public List<String> getSharedWithUsers();
	
	public List<String> getSharedWithGroup();
	
	public String getOwner();
	
	public void finalize();
	
	public boolean isFinalized();
	
	
}
