/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl.operation.tasks;

import com.google.common.collect.Maps;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TaskManagerProxy;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.DefaultTask;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.TaskUpdater;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.td.commons.webservice.exception.NoSuchTaskException;
import org.gcube.data.td.commons.webservice.types.TaskInfo;

public class TaskFactory {
    private static Map<String, DefaultTask> tasks = Maps.newHashMap();

    public static Task createTask(TaskInfo taskInfo, TaskManagerProxy proxy) {
        if (!tasks.containsKey(taskInfo.getIdentifier())) {
            TaskUpdater updater = new TaskUpdater(proxy);
            DefaultTask task = new DefaultTask(taskInfo, proxy, updater);
            tasks.put(task.getId().getValue(), task);
            return task;
        }
        return tasks.get(taskInfo.getIdentifier());
    }

    public static Task getTask(String taskIdentifier, TaskManagerProxy proxy) throws NoSuchTaskException {
        if (!tasks.containsKey(taskIdentifier)) {
            TaskInfo info = proxy.get(taskIdentifier);
            TaskUpdater updater = new TaskUpdater(proxy);
            DefaultTask task = new DefaultTask(info, proxy, updater);
            return task;
        }
        return tasks.get(taskIdentifier);
    }

    public void removeTask(String taskIdentifier, TaskManagerProxy proxy) throws NoSuchTaskException {
        if (tasks.containsKey(taskIdentifier)) {
            tasks.remove(taskIdentifier);
        }
        proxy.remove(taskIdentifier);
    }
}

