/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl.tabular;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.XStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.GCubeItem;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.clientlibrary.plugin.AbstractPlugin;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.HistoryManagerProxy;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.impl.HLUtils;
import org.gcube.data.analysis.tabulardata.service.impl.tabular.HistoryStepImpl;
import org.gcube.data.analysis.tabulardata.service.impl.tabular.MetadataList;
import org.gcube.data.analysis.tabulardata.service.tabular.HistoryStep;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResource;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.DescriptionMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.NameMetadata;
import org.gcube.data.analysis.tabulardata.service.tabular.metadata.TabularResourceMetadata;
import org.gcube.data.td.commons.webservice.types.HistoryData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularResourceObject
implements TabularResource {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(TabularResourceObject.class);
    private HistoryManagerProxy historyManager = (HistoryManagerProxy)AbstractPlugin.history().build();
    private static final XStream xstream = new XStream();
    private static final String ITEM_METADATA = "metadata";
    private static final String TABULAR_RESOURCE_ID = "taularResourceId";
    private String gcubeItemId;
    private TabularResourceId id;
    private MetadataList metadata;
    private String name;
    private String description;
    private String user;

    public static List<TabularResource> getAll(String user) {
        try {
            List children = HLUtils.getAppFolder(user).getChildren();
            ArrayList toReturn = Lists.newArrayList();
            for (WorkspaceItem item : children) {
                if (!(item instanceof GCubeItem)) continue;
                GCubeItem gcubeItem = (GCubeItem)item;
                TabularResourceObject trObj = new TabularResourceObject(gcubeItem);
                toReturn.add(trObj);
            }
            return toReturn;
        }
        catch (Exception e) {
            logger.error("error retrieving tabular resources ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static TabularResource get(String user, TabularResourceId id) throws NoSuchTabularResourceException {
        try {
            List children = HLUtils.getAppFolder(user).getChildren();
            for (WorkspaceItem item : children) {
                GCubeItem gcubeItem;
                TabularResourceObject trObj;
                if (!(item instanceof GCubeItem) || !(trObj = new TabularResourceObject(gcubeItem = (GCubeItem)item)).getId().equals((Object)id)) continue;
                return trObj;
            }
        }
        catch (Exception e) {
            logger.error("error retrieving tabular resources ", (Throwable)e);
            throw new RuntimeException(e);
        }
        throw new NoSuchTabularResourceException(id);
    }

    public static TabularResource create(String user, TabularResourceId id) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(TABULAR_RESOURCE_ID, id.getValue() + "");
        GCubeItem item = (GCubeItem)HLUtils.getWorkspace(user).createGcubeItem("tabularResource_" + id.getValue(), "a tabular resource", Collections.singletonList(ScopeProvider.instance.get()), user, "TabularResource", properties, HLUtils.getAppFolder(user).getId());
        System.out.println("item id is " + item.getId());
        return new TabularResourceObject(item);
    }

    public TabularResourceObject(GCubeItem item) throws InternalErrorException {
        this.gcubeItemId = item.getId();
        this.metadata = item.getItemProperties().containsKey(ITEM_METADATA) ? (MetadataList)xstream.fromXML((Reader)new StringReader((String)item.getItemProperties().get(ITEM_METADATA))) : new MetadataList();
        this.id = new TabularResourceId(Long.parseLong((String)item.getItemProperties().get(TABULAR_RESOURCE_ID)));
        this.name = item.getName();
        this.description = item.getDescription();
        this.metadata.add(new NameMetadata(this.name));
        this.metadata.add(new DescriptionMetadata(this.description));
        this.user = item.getOwner().getPortalLogin();
    }

    public <C extends TabularResourceMetadata> C getMetadata(Class<C> metadataType) throws NoSuchMetadataException {
        return this.metadata.get(metadataType);
    }

    public void removeMetadata(Class<? extends TabularResourceMetadata> metadataType) {
        this.metadata.remove(metadataType);
        this.flush();
    }

    public void setMetadata(TabularResourceMetadata metadata) {
        this.checkNameAndDescription(metadata);
        this.metadata.add(metadata);
        this.flush();
    }

    public Collection<TabularResourceMetadata> getAllMetadata() {
        return this.metadata.getAll();
    }

    public void setAllMetadata(Collection<TabularResourceMetadata> metadata) {
        for (TabularResourceMetadata singleMetadata : metadata) {
            this.checkNameAndDescription(singleMetadata);
            this.metadata.add(singleMetadata);
        }
        this.flush();
    }

    public void removeAllMetadata() {
        this.metadata.reset();
        this.flush();
    }

    public TabularResourceId getId() {
        return this.id;
    }

    public List<HistoryStep> getHistory() {
        try {
            ArrayList historySteps = Lists.newArrayList();
            List steps = this.historyManager.getHistory(this.id.getValue());
            for (HistoryData step : steps) {
                historySteps.add(new HistoryStepImpl(step));
            }
            return historySteps;
        }
        catch (Exception e) {
            logger.error("error retrievin history for tabular resource id {}", (Object)this.id);
            throw new RuntimeException(e);
        }
    }

    private void checkNameAndDescription(TabularResourceMetadata metadata) {
        if (metadata instanceof NameMetadata) {
            this.name = ((NameMetadata)metadata).getValue();
            try {
                HLUtils.getWorkspace(this.user).renameItem(this.gcubeItemId, this.name);
            }
            catch (Exception e) {
                new RuntimeException(e);
            }
        }
        if (metadata instanceof DescriptionMetadata) {
            this.description = ((DescriptionMetadata)metadata).getValue();
        }
    }

    private void flush() {
    }

    public String toString() {
        return "TabularResourceObject [historyManager=" + this.historyManager + ", gcubeItemId=" + this.gcubeItemId + ", id=" + this.id + ", metadata=" + this.metadata + ", name=" + this.name + ", description=" + this.description + ", user=" + this.user + "]";
    }
}

