package org.gcube.data.analysis.tabulardata.service.impl.operation;

import static org.gcube.data.analysis.tabulardata.clientlibrary.plugin.AbstractPlugin.*;

import java.util.List;

import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.OperationManagerProxy;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TaskManagerProxy;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.service.exception.InvalidTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.service.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.TaskFactory;
import org.gcube.data.analysis.tabulardata.service.operation.OperationInterface;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.Task.TaskId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.td.commons.webservice.exception.OperationNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationInterfaceImpl implements OperationInterface {

	private static OperationManagerProxy operationManager = operation().build();
	
	private static TaskManagerProxy taskManager = tasks().build();

	
	private static Logger logger = LoggerFactory.getLogger(OperationInterfaceImpl.class);
	
	@Override
	public List<EligibleOperation> getCapabilities() {
		return operationManager.getCapabilities();
	}

	@Override
	public List<EligibleOperation> getCapabilities(
			TabularResourceId tabularResourceId)
			throws NoSuchTabularResourceException,
			InvalidTabularResourceException {
		try {
			return operationManager.getCapabilities(tabularResourceId.getValue());
		} catch (org.gcube.data.td.commons.webservice.exception.NoSuchTabularResourceException e) {
			logger.error("table with id {} not found",tabularResourceId,e);
			throw new NoSuchTabularResourceException(tabularResourceId);
		}
	}

	@Override
	public List<EligibleOperation> getCapabilities(
			TabularResourceId tabularResourceId, ColumnLocalId columnId)
			throws NoSuchTabularResourceException,
			InvalidTabularResourceException, NoSuchColumnException {
		try {
			return operationManager.getCapabilities(tabularResourceId.getValue(), columnId.getValue());
		} catch (org.gcube.data.td.commons.webservice.exception.NoSuchTabularResourceException e) {
			logger.error("table with id {} not found",tabularResourceId,e);
			throw new NoSuchTabularResourceException(tabularResourceId);
		} catch (org.gcube.data.td.commons.webservice.exception.NoSuchColumnException e) {
			logger.error("column with id {} not found",columnId.getValue(),e);
			throw new NoSuchColumnException("column with id "+columnId.getValue()+" not found");
		}
	}

	@Override
	public Task execute(OperationInvocation invocation,
			TabularResourceId targetTabularResourceId)
			throws NoSuchTabularResourceException,
			InvalidTabularResourceException, InvalidInvocationException {
		try {
			return TaskFactory.createTask(operationManager.execute(invocation, targetTabularResourceId.getValue()), taskManager);
		} catch (org.gcube.data.td.commons.webservice.exception.NoSuchTabularResourceException e) {
			throw new NoSuchTabularResourceException(targetTabularResourceId);
		} catch (org.gcube.data.td.commons.webservice.exception.InvalidInvocationException e) {
			throw new InvalidInvocationException(e);
		} catch (OperationNotFoundException e) {
			throw new InvalidInvocationException(e);
		}
	}

	@Override
	public Table rollbackToTable(TabularResourceId tabularResourceId,
			TableId toTableId) throws NoSuchTabularResourceException,
			NoSuchTableException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<Task> getTasks(TabularResourceId tabularResourceId)
			throws NoSuchTabularResourceException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Task getTask(TaskId taskId, TabularResourceId tabularResourceId)
			throws NoSuchTaskException, NoSuchTabularResourceException {
		try {
			return TaskFactory.getTask(taskId.getValue(), taskManager);
		} catch (org.gcube.data.td.commons.webservice.exception.NoSuchTaskException e) {
			throw new NoSuchTaskException(tabularResourceId, taskId);
		}
		
	}

}
