package org.gcube.data.analysis.tabulardata.service.impl.operation.tasks;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TaskManagerProxy;
import org.gcube.data.analysis.tabulardata.operation.worker.ActivityStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.Job;
import org.gcube.data.analysis.tabulardata.operation.worker.JobResult;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.TaskJob;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.gcube.data.td.commons.webservice.exception.NoSuchTaskException;
import org.gcube.data.td.commons.webservice.types.TaskInfo;

import com.google.common.collect.Lists;


public class DefaultTask implements Task, TaskObserver, Serializable {
	
	

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private TaskUpdater updater;
	
	private TaskManagerProxy taskManager;
	
	private TaskInfo taskInfo;
	
			
	protected DefaultTask(TaskInfo taskInfo, TaskManagerProxy taskManager, TaskUpdater updater){
		this.taskInfo = taskInfo;
		this.taskManager = taskManager;
		this.updater = updater;
		this.updater.registerObserver(this);
	}
	
	@Override
	public float getProgress() {
		updater.checkUpdate();
		if (getTaskJobs().isEmpty()) return 0f;
		else return getTaskJobs().get(0).getProgress();
	}

	@Override
	public ActivityStatus getStatus() {
		updater.checkUpdate();
		return taskInfo.getStatus();
	}

	@Override
	public OperationInvocation getSourceInvocation() {
		//TODO change it
		if (getTaskJobs().isEmpty()) return null;
		return getTaskJobs().get(0).getSourceInvocation();
	}

	@Override
	public JobResult getResult() {
		updater.checkUpdate();
		if (getTaskJobs().isEmpty()) return null;
		return getTaskJobs().get(0).getResult();
	}

	@Override
	public TaskId getId() {
		return new TaskId(taskInfo.getIdentifier());
	}

	@Override
	public List<TaskJob> getTaskJobs() {
		updater.checkUpdate();
		List<TaskJob> taskJobs = Lists.newArrayList();
		if (taskInfo.getJobs()!=null){
			for(Job job: taskInfo.getJobs())
				taskJobs.add(new TaskJobImpl(job));
		}
		return taskJobs;
	}

	@Override
	public Date getStartTime() {
		return taskInfo.getStartTime().getTime();
	}

	@Override
	public Date getEndTime() {
		updater.checkUpdate();
		return taskInfo.getEndTime().getTime();
	}

	@Override
	public String getInvokerUsername() {
		//TODO change it
		return "";
	}

	@Override
	public List<TabularResourceId> getCollateralTabularResourceIds() {
		//TODO change it
		return null;
	}

	@Override
	public void abort() {
		try {
			taskManager.abort(this.getId().getValue());
		} catch (NoSuchTaskException e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public void notify(TaskInfo task) {
		this.taskInfo = task;
	}

	@Override
	public String getObserverIdentifier() {
		return this.taskInfo.getIdentifier();
	}

}
