package org.gcube.data.analysis.tabulardata.service.impl.operation.tasks;

import java.io.Serializable;

import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TaskManagerProxy;
import org.gcube.data.td.commons.webservice.types.TaskInfo;

public class TaskUpdater implements Serializable {

		
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private TaskManagerProxy proxy;
	
	private final long MILLIS_FOR_UPDATE = 5000;
	
	Long timestamp;  
	
	private TaskObserver observer;
	
	public TaskUpdater(TaskManagerProxy proxy) {
		super();
		this.proxy = proxy;
		this.timestamp = System.currentTimeMillis();
	}
	
	void registerObserver(TaskObserver observer){
		this.observer = observer;
	}
	
	
	
	void checkUpdate(){
		long actualTimestamp =System.currentTimeMillis();
		if (observer!=null && ((actualTimestamp-timestamp)>MILLIS_FOR_UPDATE)){
			notifiesObservers(callUpdate());
			timestamp = System.currentTimeMillis();
		}
	}

	private TaskInfo callUpdate() {
		try {
			return proxy.get(observer.getObserverIdentifier());
		} catch (Exception e) {
			throw new RuntimeException("error updating task, not found on server");
		}
	}
	
	private void notifiesObservers(TaskInfo task){
		observer.notify(task);
	}
	
	public void removeObserver(String observerIdentifier){
		this.observer = null;
	}
}
