package org.gcube.data.analysis.tabulardata.service.impl.tabular;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.gcube.data.analysis.tabulardata.service.tabular.metadata.TabularResourceMetadata;

public class MetadataList {

	private Map<Class<? extends TabularResourceMetadata>,  TabularResourceMetadata > metadata = new HashMap<Class<? extends TabularResourceMetadata>, TabularResourceMetadata>();

	/**
	 * @return the metadata
	 */
	public Collection<TabularResourceMetadata> getAll() {
		return metadata.values();
	}

	@SuppressWarnings("unchecked")
	public <T extends TabularResourceMetadata> T get(Class<T> metadataClass ){
		return (T)metadata.get(metadataClass);
	}
	
	public void reset(){
		metadata = new HashMap<Class<? extends TabularResourceMetadata>, TabularResourceMetadata>();
	}

	public  <T extends TabularResourceMetadata> void add(T metadataEntry){
		metadata.put(metadataEntry.getClass(), metadataEntry);
	}

	@SuppressWarnings("unchecked")
	public <T extends TabularResourceMetadata> T remove(Class<T> metadataClass ){
		return (T)metadata.remove(metadataClass);
	}
}
