/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.impl.operation.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.clientlibrary.plugin.AbstractPlugin;
import org.gcube.data.analysis.tabulardata.clientlibrary.proxy.TaskManagerProxy;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskInfo;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.TaskObject;
import org.gcube.data.analysis.tabulardata.service.impl.operation.tasks.TaskUpdater;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.TaskId;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskFactory {
    private static Logger logger = LoggerFactory.getLogger(TaskFactory.class);
    private static Map<String, TaskFactory> factoryPerScope = new HashMap<String, TaskFactory>();
    private Map<String, Task> tasks = new HashMap<String, Task>();
    private TaskUpdater updater;
    private String scope;

    public static TaskFactory getFactory() {
        String scope = ScopeProvider.instance.get();
        if (!factoryPerScope.containsKey(scope)) {
            factoryPerScope.put(scope, new TaskFactory(scope));
        }
        return factoryPerScope.get(scope);
    }

    public TaskFactory(String scope) {
        this.scope = scope;
        this.updater = new TaskUpdater(this.scope);
    }

    public Task createTask(TaskInfo taskInfo) {
        if (!ScopeProvider.instance.get().equals(this.scope)) {
            throw new RuntimeException("Invalid Scope Exception (actual scope is different to factory scope)");
        }
        TaskObject task = new TaskObject(taskInfo);
        logger.debug("======== " + task);
        if (!task.getStatus().isFinal()) {
            task.setUpdater(this.updater);
        }
        this.tasks.put(task.getId().getValue(), task);
        return task;
    }

    public Task getTask(TaskId taskIdentifier) throws NoSuchTaskException {
        if (!ScopeProvider.instance.get().equals(this.scope)) {
            throw new RuntimeException("Invalid Scope Exception (actual scope is different to factory scope)");
        }
        if (!this.tasks.containsKey(taskIdentifier)) {
            List tasks = ((TaskManagerProxy)AbstractPlugin.tasks().build()).get(new String[]{taskIdentifier.getValue()});
            if (tasks.size() == 0) {
                throw new NoSuchTaskException(taskIdentifier.getValue());
            }
            TaskObject task = new TaskObject((TaskInfo)tasks.get(0));
            if (!task.getStatus().isFinal()) {
                task.setUpdater(this.updater);
            }
            return task;
        }
        return this.tasks.get(taskIdentifier);
    }

    public List<Task> getTasks(TabularResourceId tabularResourceId, TaskStatus status) throws NoSuchTabularResourceException {
        if (!ScopeProvider.instance.get().equals(this.scope)) {
            throw new RuntimeException("Invalid Scope Exception (actual scope is different to factory scope)");
        }
        ArrayList<Task> taskInfos = new ArrayList<Task>();
        List infos = null;
        infos = status == null ? ((TaskManagerProxy)AbstractPlugin.tasks().build()).getTasksByTabularResource(tabularResourceId.getValue()) : ((TaskManagerProxy)AbstractPlugin.tasks().build()).getTasksByTabularResource(tabularResourceId.getValue(), status);
        for (TaskInfo info : infos) {
            if (this.tasks.containsKey(info.getIdentifier())) {
                taskInfos.add(this.tasks.get(info.getIdentifier()));
                continue;
            }
            TaskObject task = new TaskObject(info);
            if (!task.getStatus().isFinal()) {
                task.setUpdater(this.updater);
            }
            taskInfos.add(task);
        }
        return taskInfos;
    }
}

