package org.gcube.data.td.commons.webservice;

import java.util.List;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;
import javax.jws.soap.SOAPBinding.Style;
import javax.jws.soap.SOAPBinding.Use;

import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.td.commons.utils.Constants;
import org.gcube.data.td.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.td.commons.webservice.types.HistoryData;


@WebService(targetNamespace=Constants.TNS)
@SOAPBinding(style = Style.DOCUMENT, use=Use.LITERAL)
public interface HistoryManager {

	public static final String SERVICE_NAME = "historymanager";
	
	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	Table getLastTable(long tabularResourceId) throws NoSuchTabularResourceException;

	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	List<HistoryData> getHistory(long tabularResourceId)
			throws NoSuchTabularResourceException;
}
