/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.StorableTabularResource;

@Entity
public class StorableHistoryStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected long id;
    @Column
    private Long tableId;
    @Column
    boolean containsDiff = false;
    private OperationExecution operationExecution;
    @Column
    boolean tableComplete = true;
    @ManyToMany(mappedBy="historySteps", cascade={CascadeType.ALL})
    private List<StorableTabularResource> tabularResources = new ArrayList();
    @Lob
    @Column
    private String operationDescription;
    @Column
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar date;

    public StorableHistoryStep(Long tableId, OperationExecution operationExecution, String operationDescription) {
        this.tableId = tableId;
        this.operationExecution = operationExecution;
        this.operationDescription = operationDescription;
        this.date = Calendar.getInstance();
    }

    protected StorableHistoryStep() {
    }

    public Long getTableId() {
        return this.tableId;
    }

    public long getId() {
        return this.id;
    }

    public Calendar getDate() {
        return this.date;
    }

    public void setTableId(long tableId) {
        this.tableId = tableId;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public List<StorableTabularResource> getTabularResources() {
        return this.tabularResources;
    }

    public void addTabularResource(StorableTabularResource tabularResource) {
        this.tabularResources.add(tabularResource);
    }

    public boolean isTableComplete() {
        return this.tableComplete;
    }

    public void setTableComplete(boolean tableComplete) {
        this.tableComplete = tableComplete;
    }

    public boolean isContainsDiff() {
        return this.containsDiff;
    }

    public void setContainsDiff(boolean containsDiff) {
        this.containsDiff = containsDiff;
    }

    public String getOperationDescription() {
        return this.operationDescription;
    }

    public OperationExecution getOperationInvocation() {
        return this.operationExecution;
    }

    public String toString() {
        return "StorableHistoryStep [id=" + this.id + ", operationExecution=" + this.operationExecution + ", operationDescription=" + this.operationDescription + ", date=" + this.date + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.containsDiff ? 1231 : 1237);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorableHistoryStep other = (StorableHistoryStep)obj;
        if (this.containsDiff != other.containsDiff) {
            return false;
        }
        return this.id == other.id;
    }
}

