/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.metadata;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Template;
import org.gcube.data.analysis.tabulardata.metadata.Identifiable;

@Entity
@Table
@NamedQueries(value={@NamedQuery(name="Template.getAll", query="SELECT DISTINCT str FROM StorableTemplate str LEFT JOIN str.sharedWith s WHERE  ((CONCAT('u(',:user,')') = s) or (CONCAT('g(',:group,')') = s) or str.owner = :user) and :scope MEMBER OF str.scopes ORDER BY str.creationDate DESC"), @NamedQuery(name="Template.getById", query="SELECT DISTINCT str FROM StorableTemplate str LEFT JOIN str.sharedWith s WHERE  str.id = :id and ((CONCAT('u(',:user,')') = s) or (CONCAT('g(',:group,')') = s) or str.owner = :user) and :scope MEMBER OF str.scopes")})
public class StorableTemplate
implements Identifiable {
    @Column
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @Column(nullable=false)
    private String name;
    @Column(nullable=false)
    private String description;
    @Column
    private String agency;
    @Column(nullable=false)
    private String owner;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar creationDate = Calendar.getInstance();
    @ElementCollection(targetClass=String.class, fetch=FetchType.EAGER)
    private List<String> sharedWith = new ArrayList();
    @ElementCollection
    private List<String> scopes = new ArrayList();
    private Template template;

    private StorableTemplate() {
    }

    public StorableTemplate(String name, String description, String agency, String owner, String scope, Template template) {
        this.name = name;
        this.description = description;
        this.agency = agency;
        this.owner = owner;
        this.template = template;
        this.scopes.add(scope);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAgency() {
        return this.agency;
    }

    public void setAgency(String agency) {
        this.agency = agency;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public List<String> getSharedWith() {
        return this.sharedWith;
    }

    public void setSharedWith(List<String> sharedWith) {
        this.sharedWith = sharedWith;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public long getId() {
        return this.id;
    }
}

