/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.metadata.task;

import java.util.Calendar;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskInfo;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.StorableTabularResource;
import org.gcube.data.analysis.tabulardata.task.TaskContext;

@Entity
@NamedQuery(name="TASK.getByTr", query="SELECT DISTINCT task FROM StorableTabularResource str JOIN str.tasks task LEFT JOIN str.sharedWith s  WHERE str.id = :trid and ((CONCAT('u(',:user,')') = s) or (CONCAT('g(',:group,')') = s) or str.owner = :user) and :scope MEMBER OF str.scopes and str.hidden=false  ORDER BY task.startTime DESC")
public class StorableTask {
    @Column
    @Id
    private String identifier;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar startTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar endTime;
    private TaskInfo storedTask;
    @OneToOne(cascade={CascadeType.ALL})
    private TaskContext taskContext;
    @ManyToOne
    private StorableTabularResource tabularResource;
    @Column
    private TaskInfo.TaskType type;

    private StorableTask() {
    }

    public StorableTask(TaskInfo task, StorableTabularResource tabularResource) {
        this.storedTask = task;
        this.identifier = task.getIdentifier();
        this.startTime = task.getStartTime();
        this.endTime = task.getEndTime();
        this.type = task.getType();
        this.tabularResource = tabularResource;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Calendar startTime) {
        this.startTime = startTime;
    }

    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Calendar endTime) {
        this.endTime = endTime;
    }

    public TaskInfo getStoredTask() {
        return this.storedTask;
    }

    public void setStoredTask(TaskInfo storedTask) {
        this.storedTask = storedTask;
        this.startTime = storedTask.getStartTime();
        this.endTime = storedTask.getEndTime();
    }

    public TaskInfo.TaskType getTaskType() {
        return this.type;
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public StorableTabularResource getTabularResource() {
        return this.tabularResource;
    }

    public String toString() {
        return "StorableTask [identifier=" + this.identifier + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", taskContext=" + this.taskContext + ", type=" + this.type + "]";
    }
}

