/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.RollbackException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Template;
import org.gcube.data.analysis.tabulardata.commons.utils.SharingEntity;
import org.gcube.data.analysis.tabulardata.commons.webservice.TemplateManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTemplateException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.TemplateNotCompatibleException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TemplateDescription;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskInfo;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.exceptions.NoSuchObjectException;
import org.gcube.data.analysis.tabulardata.metadata.StorableTemplate;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.StorableTabularResource;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.SharingHelper;
import org.gcube.data.analysis.tabulardata.task.RunnableTask;
import org.gcube.data.analysis.tabulardata.task.TaskContext;
import org.gcube.data.analysis.tabulardata.task.engine.TaskEngine;
import org.gcube.data.analysis.tabulardata.templates.TemplateEngine;
import org.gcube.data.analysis.tabulardata.templates.TemplateEngineFactory;
import org.gcube.data.analysis.tabulardata.utils.EntityManagerHelper;
import org.gcube.data.analysis.tabulardata.utils.OperationUtil;
import org.gcube.data.analysis.tabulardata.utils.Util;
import org.gcube.data.analysis.tabulardata.weld.WeldService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="TemplateManagerPort", serviceName="templatemanager", targetNamespace="http://gcube-system.org/template", endpointInterface="org.gcube.data.analysis.tabulardata.commons.webservice.TemplateManager")
@Singleton
@WeldService
public class TemplateManagerImpl
implements TemplateManager {
    private Logger logger = LoggerFactory.getLogger(TemplateManagerImpl.class);
    @Inject
    TaskEngine taskEngine;
    @Inject
    OperationUtil opUtil;
    @Inject
    CubeManager cm;
    @Inject
    TemplateEngineFactory templateEngineFactory;
    @Inject
    EntityManagerHelper emHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long saveTemplate(String name, String description, String agency, Template template) throws InternalSecurityException {
        this.logger.debug("saving template");
        String owner = AuthorizationProvider.instance.get().getClient().getId();
        StorableTemplate storableTemplate = new StorableTemplate(name, description, agency, owner, ScopeProvider.instance.get(), template);
        try (EntityManager em = this.emHelper.getEntityManager();){
            em.getTransaction().begin();
            em.persist((Object)storableTemplate);
            em.getTransaction().commit();
        }
        return storableTemplate.getId();
    }

    public TemplateDescription removeTemplate(long id) throws NoSuchTemplateException, InternalSecurityException {
        try (EntityManager em = this.emHelper.getEntityManager();){
            StorableTemplate st = (StorableTemplate)Util.getOwnerhipAuthorizedObject((Object)id, StorableTemplate.class, (EntityManager)em);
            try {
                em.getTransaction().begin();
                em.remove((Object)st);
                em.getTransaction().commit();
            }
            catch (RollbackException re) {
                this.logger.error("error on transaction code", (Throwable)re);
                em.clear();
                throw re;
            }
            catch (DatabaseException de) {
                this.logger.error("database error code is " + de.getDatabaseErrorCode(), (Throwable)de);
                em.getTransaction().rollback();
                throw de;
            }
            TemplateDescription templateDescription = Util.toTemplateDescription((StorableTemplate)st);
            return templateDescription;
        }
    }

    public TemplateDescription updateTemplate(long id, Template template) throws NoSuchTemplateException, InternalSecurityException {
        try (EntityManager em = this.emHelper.getEntityManager();){
            StorableTemplate st = (StorableTemplate)Util.getOwnerhipAuthorizedObject((Object)id, StorableTemplate.class, (EntityManager)em);
            st.setTemplate(template);
            try {
                em.getTransaction().begin();
                em.merge((Object)st);
                em.getTransaction().commit();
            }
            catch (RollbackException re) {
                this.logger.error("error on transaction code", (Throwable)re);
                em.clear();
                throw re;
            }
            catch (DatabaseException de) {
                this.logger.error("database error code is " + de.getDatabaseErrorCode(), (Throwable)de);
                em.getTransaction().rollback();
                throw de;
            }
            TemplateDescription templateDescription = Util.toTemplateDescription((StorableTemplate)st);
            return templateDescription;
        }
    }

    public List<TemplateDescription> getTemplates() throws InternalSecurityException {
        String caller = AuthorizationProvider.instance.get().getClient().getId();
        HashMap<String, String> parameters = new HashMap<String, String>(3);
        parameters.put("user", caller);
        parameters.put("scope", ScopeProvider.instance.get());
        parameters.put("group", ScopeProvider.instance.get());
        List storedTemplateResources = this.emHelper.getResults("Template.getAll", StorableTemplate.class, parameters);
        ArrayList<TemplateDescription> templates = new ArrayList<TemplateDescription>();
        for (StorableTemplate str : storedTemplateResources) {
            templates.add(Util.toTemplateDescription((StorableTemplate)str));
        }
        return templates;
    }

    public TemplateDescription getTemplate(long id) throws NoSuchTemplateException, InternalSecurityException {
        String caller = AuthorizationProvider.instance.get().getClient().getId();
        HashMap<String, Object> parameters = new HashMap<String, Object>(4);
        parameters.put("user", caller);
        parameters.put("scope", ScopeProvider.instance.get());
        parameters.put("group", ScopeProvider.instance.get());
        parameters.put("id", id);
        List storedTemplates = this.emHelper.getResults("Template.getById", StorableTemplate.class, parameters);
        if (storedTemplates.size() != 1) {
            throw new NoSuchTemplateException(id);
        }
        StorableTemplate sTemplate = (StorableTemplate)storedTemplates.get(0);
        return Util.toTemplateDescription((StorableTemplate)sTemplate);
    }

    public TemplateDescription share(Long entityId, SharingEntity ... entities) throws NoSuchTemplateException, InternalSecurityException {
        try (EntityManager em = this.emHelper.getEntityManager();){
            TemplateDescription templateDescription = Util.toTemplateDescription((StorableTemplate)((StorableTemplate)SharingHelper.share(StorableTemplate.class, (Object)entityId, (EntityManager)em, (SharingEntity[])entities)));
            return templateDescription;
        }
    }

    public TemplateDescription unshare(Long entityId, SharingEntity ... entities) throws NoSuchTemplateException, InternalSecurityException {
        try (EntityManager em = this.emHelper.getEntityManager();){
            TemplateDescription templateDescription = Util.toTemplateDescription((StorableTemplate)((StorableTemplate)SharingHelper.unshare(StorableTemplate.class, (Object)entityId, (EntityManager)em, (SharingEntity[])entities)));
            return templateDescription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskInfo apply(long templateId, long tabularResourceId) throws NoSuchTemplateException, NoSuchTabularResourceException, TemplateNotCompatibleException, InternalSecurityException {
        try (EntityManager em = this.emHelper.getEntityManager();){
            TaskContext context;
            StorableTemplate storableTemplate;
            StorableTabularResource storableTabularResource;
            try {
                storableTabularResource = (StorableTabularResource)Util.getUserAuthorizedObject((Object)tabularResourceId, StorableTabularResource.class, (EntityManager)em);
            }
            catch (NoSuchObjectException e) {
                throw new NoSuchTabularResourceException(tabularResourceId);
            }
            try {
                storableTemplate = (StorableTemplate)Util.getUserAuthorizedObject((Object)templateId, StorableTemplate.class, (EntityManager)em);
            }
            catch (NoSuchObjectException e) {
                throw new NoSuchTemplateException(templateId);
            }
            String submitter = AuthorizationProvider.instance.get().getClient().getId();
            if (storableTabularResource.getHistorySteps().size() == 0) {
                throw new RuntimeException("templates can be applyed only to TabularResource with at least a table");
            }
            long lastTableId = storableTabularResource.getTableId();
            Table table = this.cm.getTable(new TableId(lastTableId));
            TemplateEngine templateEngine = this.templateEngineFactory.getEngine(storableTemplate.getTemplate(), table);
            try {
                context = new TaskContext(templateEngine.getTemplateSteps(), storableTemplate.getTemplate().getOnRowErrorAction());
                this.opUtil.addPostOperations(context);
                this.opUtil.addPostValidations(context, storableTabularResource);
            }
            catch (TemplateNotCompatibleException tnc) {
                throw tnc;
            }
            catch (Throwable e) {
                throw new RuntimeException("error applying template", e);
            }
            TaskInfo taskInfo = this.taskEngine.createTemplateTask(submitter, context, storableTabularResource, templateId, (RunnableTask)templateEngine.getInvocationForFinalAction());
            return taskInfo;
        }
    }
}

