/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.task.executor.workers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.Result;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidityResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;
import org.gcube.data.analysis.tabulardata.task.executor.operation.OperationContext;
import org.gcube.data.analysis.tabulardata.task.executor.operation.PreconditionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class WorkerExecutor {
    private static Logger logger = LoggerFactory.getLogger(WorkerExecutor.class);
    private Worker<?> actualWorker = null;
    private boolean aborted = false;
    protected OperationContext operationContext;

    public WorkerExecutor(OperationContext operationContext) {
        this.operationContext = operationContext;
    }

    public Result executeOperation(Worker<?> worker) throws WorkerException, OperationAbortedException {
        this.actualWorker = worker;
        worker.run();
        if (this.aborted) {
            throw new OperationAbortedException();
        }
        if (worker.getStatus() == WorkerStatus.FAILED) {
            throw worker.getException();
        }
        Result result = worker.getResult();
        return result;
    }

    public void executeValidations(List<ValidationWorker> preconditionsWorker) throws WorkerException, OperationAbortedException {
        boolean valid = true;
        ArrayList validationDescriptors = new ArrayList();
        Iterator<ValidationWorker> validationWorkerIt = preconditionsWorker.iterator();
        while (validationWorkerIt.hasNext() && !this.aborted) {
            ValidationWorker validationWorker = validationWorkerIt.next();
            this.actualWorker = validationWorker;
            validationWorker.run();
            if (validationWorker.getStatus() == WorkerStatus.FAILED) {
                throw validationWorker.getException();
            }
            if (validationWorker.getStatus() == WorkerStatus.ABORTED) {
                throw new OperationAbortedException();
            }
            logger.trace("is precondition " + validationWorker.getSourceInvocation().getOperationDescriptor().getName() + " valid? " + ((ValidityResult)validationWorker.getResult()).isValid());
            validationDescriptors.addAll(WorkerExecutor.getValidationDescriptions((ValidityResult)((ValidityResult)validationWorker.getResult())));
            valid &= ((ValidityResult)validationWorker.getResult()).isValid();
        }
        if (this.aborted) {
            throw new OperationAbortedException();
        }
        logger.trace("are precondition valid? " + valid);
        this.operationContext.setPreconditionResult(new PreconditionResult(valid, validationDescriptors));
    }

    public static List<org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.ValidationDescriptor> getValidationDescriptions(ValidityResult result) {
        ArrayList<org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.ValidationDescriptor> validations = new ArrayList<org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.ValidationDescriptor>();
        for (ValidationDescriptor vd : result.getValidationDescriptors()) {
            org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.ValidationDescriptor descriptor = new org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.ValidationDescriptor(vd.getDescription(), vd.isValid(), vd.getConditionCode());
            if (vd.getValidationColumn() != null) {
                descriptor.setValidationColumn(vd.getValidationColumn().getValue());
            }
            validations.add(descriptor);
        }
        return validations;
    }

    public void abort() {
        if (this.actualWorker != null) {
            this.actualWorker.abort();
        }
        this.aborted = true;
    }
}

