/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.datatype;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDText;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;

@XmlRootElement(name="Text")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TextType
extends DataType {
    private static final long serialVersionUID = 3012818814370962508L;
    private int length;

    public TextType() {
        this.length = 256;
    }

    @Deprecated
    public TextType(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("Length must be greater than 0.");
        }
        this.length = length;
    }

    @Deprecated
    public int getLenght() {
        return this.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.length;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextType other = (TextType)obj;
        return this.length == other.length;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Text [lenght=");
        builder.append(this.length);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String getName() {
        return "Text";
    }

    @Override
    public TDTypeValue getDefaultValue() {
        return new TDText(" ");
    }

    @Override
    public TDTypeValue fromString(String value) {
        return new TDText(value.length() <= this.length ? value : value.substring(0, this.length - 1));
    }
}

