/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.expression.evaluator.EvaluatorException;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.exceptions.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.query.TabularQuery;
import org.gcube.data.analysis.tabulardata.query.TabularQueryUtils;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryFilter;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryPage;
import org.gcube.data.analysis.tabulardata.query.parameters.group.QueryGroup;
import org.gcube.data.analysis.tabulardata.query.parameters.select.QueryColumn;
import org.gcube.data.analysis.tabulardata.query.parameters.select.QuerySelect;
import org.gcube.data.analysis.tabulardata.query.sql.SQLResultSetIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularQueryImpl
implements TabularQuery {
    private static Logger log = LoggerFactory.getLogger(TabularQueryImpl.class);
    private TabularQueryUtils queryUtils;
    private Table table;
    private QuerySelect select = null;
    private QueryFilter filter = null;
    private QueryOrder ordering = null;
    private QueryGroup grouping = null;
    private QueryPage page;
    private QueryBuilder queryBuilder = new QueryBuilder();
    private SQLExpressionEvaluatorFactory evaluatorFactory;

    public TabularQueryImpl(TabularQueryUtils queryUtils, SQLExpressionEvaluatorFactory evaluatorFactory, Table table) {
        this.queryUtils = queryUtils;
        this.evaluatorFactory = evaluatorFactory;
        this.table = table;
    }

    @Override
    public TabularQuery setFilter(QueryFilter filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public TabularQuery setOrdering(QueryOrder ordering) {
        this.ordering = ordering;
        return this;
    }

    @Override
    public TabularQuery setGrouping(QueryGroup grouping) {
        this.grouping = grouping;
        return this;
    }

    @Override
    public TabularQuery setSelection(QuerySelect selection) {
        this.select = selection;
        return this;
    }

    @Override
    public int getTotalTuples() {
        String sql = this.queryBuilder.buildCountTuplesQuery();
        ResultSet rs = this.queryUtils.executeSQLQuery(sql);
        int totalTuples = this.parseGetTotalTuplesQueryResult(rs);
        return totalTuples;
    }

    @Override
    public Iterator<Object[]> getPage(QueryPage page) {
        this.page = page;
        return this.executeQuery();
    }

    @Override
    public Iterator<Object[]> getAll() {
        this.page = null;
        return this.executeQuery();
    }

    private Iterator<Object[]> executeQuery() {
        String query = this.queryBuilder.buildQuery();
        return new SQLResultSetIterator(this.queryUtils.executeSQLQuery(query));
    }

    private int parseGetTotalTuplesQueryResult(ResultSet rs) {
        try {
            rs.next();
            int result = rs.getInt(1);
            DbUtils.closeQuietly((ResultSet)rs);
            return result;
        }
        catch (SQLException e) {
            log.error("An error occurred while querying the database.", (Throwable)e);
            throw new RuntimeException("An error occurred while querying the database. Check server logs");
        }
    }

    private class QueryBuilder {
        private QueryBuilder() {
        }

        private String buildQuery() {
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append(this.getQuerySelectPart());
            queryBuilder.append(this.getQueryFilterPart());
            queryBuilder.append(this.getQueryGroupingPart());
            queryBuilder.append(this.getQueryOrderPart());
            queryBuilder.append(this.getLimitQueryPart());
            queryBuilder.append(";");
            return queryBuilder.toString();
        }

        private String getQueryGroupingPart() {
            if (TabularQueryImpl.this.grouping == null || TabularQueryImpl.this.grouping.getColumns().isEmpty()) {
                return "";
            }
            return String.format("GROUP BY %s ", this.buildColumnCommaSeparatedList(TabularQueryImpl.this.grouping.getColumns()));
        }

        private String getQuerySelectPart() {
            String columns = "";
            columns = TabularQueryImpl.this.select != null ? this.buildQueryColumnCommaSeparatedList(TabularQueryImpl.this.select.getColumns()) : this.buildColumnNameCommaSeparatedList(TabularQueryImpl.this.table.getColumns());
            return String.format("SELECT %s FROM %s ", columns, TabularQueryImpl.this.table.getName());
        }

        private String getQueryFilterPart() {
            String whereCondition;
            if (TabularQueryImpl.this.filter == null) {
                return "";
            }
            try {
                whereCondition = (String)TabularQueryImpl.this.evaluatorFactory.getEvaluator(TabularQueryImpl.this.filter.getFilterExpression()).evaluate();
            }
            catch (EvaluatorException e) {
                log.warn("Unable to evaluate expression, skipping WHERE clause.", (Throwable)e);
                return "";
            }
            return String.format(" WHERE %s ", whereCondition);
        }

        private String getQueryOrderPart() {
            Column orderingColumn;
            if (TabularQueryImpl.this.ordering == null) {
                return "";
            }
            try {
                orderingColumn = TabularQueryImpl.this.table.getColumnById(TabularQueryImpl.this.ordering.getOrderingColumnId());
            }
            catch (NoSuchColumnException e) {
                String msg = String.format("Provided ordering column name '%s' does not exists within table %s.", TabularQueryImpl.this.ordering.getOrderingColumnId(), TabularQueryImpl.this.table);
                log.warn(msg + "\nSkipping ordering clause.");
                return "";
            }
            return String.format(" ORDER BY %s %s ", orderingColumn.getName(), TabularQueryImpl.this.ordering.getOrderingDirection().getSQLKeyword());
        }

        private String getLimitQueryPart() {
            if (TabularQueryImpl.this.page == null) {
                return "";
            }
            return String.format(" LIMIT %s OFFSET %s ", TabularQueryImpl.this.page.getPageSize(), TabularQueryImpl.this.page.getOffset());
        }

        private String buildQueryColumnCommaSeparatedList(Collection<QueryColumn> columns) {
            StringBuilder columnNames = new StringBuilder();
            int i = 0;
            System.out.println("size of select columns is " + columns.size());
            for (QueryColumn c : columns) {
                Column col = TabularQueryImpl.this.table.getColumnById(c.getColumnLocalId());
                switch (c.getFunction()) {
                    case COUNT: {
                        columnNames.append("count(").append(col.getName()).append(")");
                        break;
                    }
                    case MAX: {
                        columnNames.append("max(").append(col.getName()).append(")");
                        break;
                    }
                    case MIN: {
                        columnNames.append("min(").append(col.getName()).append(")");
                        break;
                    }
                    case AVERAGE: {
                        columnNames.append("avg(").append(col.getName()).append(")");
                        break;
                    }
                    default: {
                        columnNames.append(col.getName());
                    }
                }
                if (++i >= columns.size()) continue;
                columnNames.append(",");
            }
            return columnNames.toString();
        }

        private String buildColumnCommaSeparatedList(Collection<ColumnLocalId> columns) {
            StringBuilder columnNames = new StringBuilder();
            int i = 0;
            for (ColumnLocalId cId : columns) {
                Column c = TabularQueryImpl.this.table.getColumnById(cId);
                columnNames.append(c.getName());
                if (++i >= columns.size()) continue;
                columnNames.append(",");
            }
            return columnNames.toString();
        }

        private String buildColumnNameCommaSeparatedList(Collection<Column> columns) {
            StringBuilder columnNames = new StringBuilder();
            int i = 0;
            for (Column c : columns) {
                columnNames.append(c.getName());
                if (++i >= columns.size()) continue;
                columnNames.append(",");
            }
            return columnNames.toString();
        }

        private String buildCountTuplesQuery() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.buildSelectCountFirstPart());
            stringBuilder.append(this.getQueryFilterPart());
            stringBuilder.append(";");
            return stringBuilder.toString();
        }

        private String buildSelectCountFirstPart() {
            return String.format("SELECT COUNT(*) FROM %s ", TabularQueryImpl.this.table.getName());
        }
    }
}

