package org.gcube.data.fishfinder.tmplugin.utils;

import static org.gcube.data.trees.data.Nodes.e;

import java.io.Serializable;

import org.gcube.data.fishfinder.tmplugin.RepositoryProvider;
import org.gcube.data.fishfinder.tmplugin.repository.iterators.FishFinderRecord;
import org.gcube.data.fishfinder.tmplugin.requests.Request;
import org.gcube.data.trees.data.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
/**
 * @author "Valentina Marioli valentina.marioli@isti.cnr.it"
 *
 */

public class FishFinderTreeGenerator implements Serializable {

	private static final long serialVersionUID = -8037198825787888863L;

	private static final String URLFAO = "http://www.fao.org/";
	private final static Logger log = LoggerFactory.getLogger(FishFinderTreeGenerator.class);

	//	private Request request;
	//	private String scientificName;

	public FishFinderTreeGenerator(Request req) {	
		super();	
		//		this.request = req;
		log.info("Figis Tree Generator");
	}

	//backdoor for testing
	public FishFinderTreeGenerator(RepositoryProvider p) {

	}

	public Tree bind(FishFinderRecord record) throws Exception {
		//		log.info(this.scientificName);
		Tree tree = null;
		try{
			tree = new Tree(record.getThree_alpha_cod());
			tree.add(e("title",record.scientific_name + " " + record.personal_author +" - Fact sheet"));
			tree.add(e("three_alpha_code",record.getThree_alpha_cod()));
			tree.add(e("name_en",record.name_en));
			tree.add(e("name_fr",record.name_fr));
			tree.add(e("name_es",record.name_es));
			tree.add(e("images", URLFAO + record.images));
			tree.add(e("scientific_name",record.scientific_name));
			tree.add(e("family",record.family));
			tree.add(e("personal_author",record.personal_author));
			tree.add(e("year",record.year));
			tree.add(e("diagnostic_features",record.diagnostic_features));
			tree.add(e("area_text",record.area_text));
			tree.add(e("habitat_bio",record.habitat_bio));
			tree.add(e("interest_fisheries",record.interest_fisheries));
			tree.add(e("local_names",record.local_names));
			tree.add(e("factsheet_url",record.factsheet_url));
			tree.add(e("factsheet_id",record.factsheet_id));

		}catch (Exception e) {
			log.error("Error creating Tree in Figis Plugin ", e);
		}

		return tree;
	}


}