package org.gcube.data.fishfinder.tmplugin.repository.iterators;

import java.net.URI;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.gcube.data.fishfinder.tmplugin.dbconnection.FishFinderTable;
import org.gcube.data.streams.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
/**
 * @author "Valentina Marioli valentina.marioli@isti.cnr.it"
 *
 */
public class RecordIterator implements Stream<FishFinderRecord> {

	private static Logger log = LoggerFactory.getLogger(RecordIterator.class);

	ResultSet rs = null;
	Boolean finished = false;
	Boolean closed = false;

	public RecordIterator(){
		log.trace("Iterator Figis Records");
		try{
			FishFinderTable figisTable = new FishFinderTable();
			this.rs = figisTable.getAllRecords();			
		}catch (Exception e) {
			log.error("Error creating FigisRecord iterator", e);
		}
	}

	//not implemented method
	@Override
	public void remove() {}

	@Override
	public boolean hasNext() {
		try {
			finished = !rs.next();
		} catch (SQLException e) {
			log.error("sql Error", e);
		}
		if (finished){
			close();
		}
		return !finished;
	}

	@Override
	public FishFinderRecord next() {
		FishFinderRecord record = null;	
		try {
			//			System.out.println(rs.getString(6));
			record = new FishFinderRecord(rs);		
		} catch (Exception e) {
			log.error("Error retrieving next FigisRecord", e);
		}

		return record;
	}

	@Override
	public URI locator() {return null;}

	@Override
	public void close() {
		try {
			if (rs != null) {
				rs.close();
			}
		} catch (SQLException ex) {
			log.error("sql Error", ex);
		}
		closed = true;

	}

	@Override
	public boolean isClosed() {
		return closed;
	}

}
