/**
 * 
 */
package org.gcube.data.fishfinder.tmplugin;

import java.util.Calendar;
import java.util.Collections;
import java.util.List;

import javax.xml.namespace.QName;

import org.gcube.data.fishfinder.tmplugin.repository.iterators.FishFinderRecord;
import org.gcube.data.fishfinder.tmplugin.repository.iterators.RecordIterator;
import org.gcube.data.fishfinder.tmplugin.utils.Utils;
import org.gcube.data.streams.Stream;
import org.gcube.data.tmf.api.Property;
import org.gcube.data.tmf.impl.AbstractSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * @author "Valentina Marioli valentina.marioli@isti.cnr.it"
 *
 */
public class FishFinderSource extends AbstractSource {

	private static Logger log = LoggerFactory.getLogger(FishFinderSource.class);
	private static final long serialVersionUID = 1187888636624642253L;
	private Long cardinality = (long) 0;
	
	/**
	 * Creates an instance with a given identifer over given sets of a given repository.
	 */
	public FishFinderSource(String id) { 
		super(id);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public List<Property> properties() {
		return null;
	}

	@Override
	public List<QName> types() {
		return Collections.singletonList(new QName("http://gcube-system.org/namespaces/data/figisplugin","FIGIS"));
	}
	
	@Override
	public FishFinderReader reader() {
		return (FishFinderReader) super.reader();
	}

	
	@Override
	public synchronized Long cardinality() {
		if (super.cardinality()==null){
			Stream<FishFinderRecord> records = new RecordIterator();
			while (records.hasNext()){
				try {
					records.next();
					cardinality++;				
				}
				catch(Exception e) {
					log.error("could not count record",e);
				}
			}
			super.setCardinality(cardinality);
		}
		return super.cardinality();
	}

	
	@Override
	public synchronized void setCardinality(Long cardinality) {
		super.setCardinality(cardinality);
	}

	
	@Override
	public synchronized Calendar lastUpdate() {
		if (super.lastUpdate()==null){
			try{
				super.setLastUpdate(Utils.lastupdate());
			}catch(Exception e) {
				log.error("could not retrieve last update",e);
			}
		}
		return super.lastUpdate();
	}


	@Override
	public synchronized void setLastUpdate(Calendar time) {
		super.setLastUpdate(time);
	}
	
}
