/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence.impl.readers.formats;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.csv4j.CSVLineProcessor;
import org.apache.commons.io.input.CountingInputStream;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.harmonization.occurrence.impl.readers.CSVParserConfiguration;
import org.gcube.data.harmonization.occurrence.impl.readers.StreamProgress;
import org.gcube.data.harmonization.occurrence.impl.readers.formats.OccurrencePointFields;
import org.gcube.data.spd.model.BasisOfRecord;
import org.gcube.data.spd.model.products.DataProvider;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.ResultWrapper;

public class OccurrenceCSVProcessor
implements CSVLineProcessor {
    protected static final SimpleDateFormat FORMAT = new SimpleDateFormat("MM/dd/yy KK:mm:ss a");
    private static final GCUBELog logger = new GCUBELog(OccurrenceCSVProcessor.class);
    private Map<OccurrencePointFields, Integer> mapping = new HashMap<OccurrencePointFields, Integer>();
    private ResultWrapper<OccurrencePoint> wrapper;
    private StreamProgress progress;
    private CSVParserConfiguration config;
    private CountingInputStream cis;
    private long pointCount = 0L;

    public OccurrenceCSVProcessor(ResultWrapper<OccurrencePoint> wrapper, StreamProgress progress, CSVParserConfiguration config, CountingInputStream cis) {
        this.wrapper = wrapper;
        this.progress = progress;
        this.config = config;
        this.cis = cis;
    }

    public boolean continueProcessing() {
        return !this.progress.getState().equals((Object)StreamProgress.OperationState.FAILED);
    }

    public void processDataLine(int arg0, List<String> arg1) {
        OccurrencePoint point = new OccurrencePoint("");
        point.setDataSet(new DataSet(""));
        point.getDataSet().setDataProvider(new DataProvider(""));
        for (Map.Entry<OccurrencePointFields, Integer> entry : this.mapping.entrySet()) {
            String columnValue = arg1.get(entry.getValue());
            switch (entry.getKey()) {
                case BASIS_OF_RECORD: {
                    try {
                        point.setBasisOfRecord(BasisOfRecord.valueOf((String)columnValue));
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Unable to evaluate basis of record : " + columnValue));
                    }
                    break;
                }
                case CATALOGUE_NUMBER: {
                    point.setCatalogueNumber(columnValue);
                    break;
                }
                case CITATION: {
                    point.setCitation(columnValue);
                    break;
                }
                case COLLECTION_CODE: {
                    point.setCollectionCode(columnValue);
                    break;
                }
                case COORDINATE_UNCERTAINTY_IN_METERS: {
                    point.setCoordinateUncertaintyInMeters(columnValue);
                    break;
                }
                case COUNTRY: {
                    point.setCountry(columnValue);
                    break;
                }
                case DATA_PROVIDER_ID: {
                    break;
                }
                case DATA_PROVIDER_NAME: {
                    point.getDataSet().getDataProvider().setName(columnValue);
                    break;
                }
                case DATA_SET_CITATION: {
                    break;
                }
                case DATA_SET_ID: {
                    break;
                }
                case DATA_SET_NAME: {
                    point.getDataSet().setName(columnValue);
                    break;
                }
                case DECIMAL_LATITUDE: {
                    try {
                        point.setDecimalLatitude(Double.parseDouble(columnValue));
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Unable to parse decimal latitude " + columnValue));
                    }
                    break;
                }
                case DECIMAL_LONGITUDE: {
                    try {
                        point.setDecimalLongitude(Double.parseDouble(columnValue));
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Unable to parse decimal longitude " + columnValue));
                    }
                    break;
                }
                case EVENT_DATE: {
                    Calendar calendar;
                    Date date;
                    try {
                        date = FORMAT.parse(columnValue);
                        calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        point.setEventDate(calendar);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Unable to parse event date : " + columnValue));
                    }
                    break;
                }
                case FAMILY: {
                    point.setFamily(columnValue);
                    break;
                }
                case ID: {
                    point.setId(columnValue);
                    break;
                }
                case INSTITUTION_CODE: {
                    point.setInstitutionCode(columnValue);
                    break;
                }
                case KINGDOM: {
                    point.setKingdom(columnValue);
                    break;
                }
                case LOCALITY: {
                    point.setLocality(columnValue);
                    break;
                }
                case MAX_DEPTH: {
                    try {
                        point.setMaxDepth(Double.parseDouble(columnValue));
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Unable to parse max depth " + columnValue));
                    }
                    break;
                }
                case MIN_DEPTH: {
                    try {
                        point.setMinDepth(Double.parseDouble(columnValue));
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Unable to parse min depth " + columnValue));
                    }
                    break;
                }
                case MODIFIED: {
                    Calendar calendar;
                    Date date;
                    try {
                        date = FORMAT.parse(columnValue);
                        calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        point.setModified(calendar);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Unable to parse modified: " + columnValue));
                    }
                    break;
                }
                case PROVIDER: {
                    point.setProvider(columnValue);
                    break;
                }
                case RECORDED_BY: {
                    point.setRecordedBy(columnValue);
                    break;
                }
                case SCIENTIFIC_NAME: {
                    point.setScientificName(columnValue);
                }
            }
        }
        try {
            this.wrapper.add((Object)point);
            this.progress.setElaboratedLenght(this.cis.getCount());
            System.out.println(this.pointCount++);
        }
        catch (Exception e) {
            this.progress.setFailureReason("Unable to stream data");
            this.progress.setFailureDetails(e.getMessage());
            this.progress.setState(StreamProgress.OperationState.FAILED);
        }
    }

    public void processHeaderLine(int arg0, List<String> arg1) {
        String s;
        int i;
        for (i = 0; i < arg1.size(); ++i) {
            if (!this.config.getFieldMap()[i]) continue;
            s = arg1.get(i);
            if (s.equals("#id")) {
                this.mapping.put(OccurrencePointFields.ID, i);
                continue;
            }
            if (s.equals("label")) {
                this.mapping.put(OccurrencePointFields.SCIENTIFIC_NAME, i);
                continue;
            }
            if (s.equals("long")) {
                this.mapping.put(OccurrencePointFields.DECIMAL_LONGITUDE, i);
                continue;
            }
            if (!s.equals("lat")) continue;
            this.mapping.put(OccurrencePointFields.DECIMAL_LATITUDE, i);
        }
        if (this.mapping.size() != 4) {
            for (i = 0; i < arg1.size(); ++i) {
                if (!this.config.getFieldMap()[i]) continue;
                s = arg1.get(i);
                if (s.equals("institutionCode")) {
                    this.mapping.put(OccurrencePointFields.INSTITUTION_CODE, i);
                    continue;
                }
                if (s.equals("collectionCode")) {
                    this.mapping.put(OccurrencePointFields.COLLECTION_CODE, i);
                    continue;
                }
                if (s.equals("catalogueNumber")) {
                    this.mapping.put(OccurrencePointFields.CATALOGUE_NUMBER, i);
                    continue;
                }
                if (s.equals("dataSet")) {
                    this.mapping.put(OccurrencePointFields.DATA_SET_NAME, i);
                    continue;
                }
                if (s.equals("dataProvider")) {
                    this.mapping.put(OccurrencePointFields.DATA_PROVIDER_NAME, i);
                    continue;
                }
                if (s.equals("dataSource")) {
                    this.mapping.put(OccurrencePointFields.PROVIDER, i);
                    continue;
                }
                if (s.equals("recordedBy")) {
                    this.mapping.put(OccurrencePointFields.RECORDED_BY, i);
                    continue;
                }
                if (s.equals("eventDate")) {
                    this.mapping.put(OccurrencePointFields.EVENT_DATE, i);
                    continue;
                }
                if (s.equals("modified")) {
                    this.mapping.put(OccurrencePointFields.MODIFIED, i);
                    continue;
                }
                if (s.equals("scientificName")) {
                    this.mapping.put(OccurrencePointFields.SCIENTIFIC_NAME, i);
                    continue;
                }
                if (s.equals("kingdom")) {
                    this.mapping.put(OccurrencePointFields.KINGDOM, i);
                    continue;
                }
                if (s.equals("family")) {
                    this.mapping.put(OccurrencePointFields.FAMILY, i);
                    continue;
                }
                if (s.equals("locality")) {
                    this.mapping.put(OccurrencePointFields.LOCALITY, i);
                    continue;
                }
                if (s.equals("country")) {
                    this.mapping.put(OccurrencePointFields.COUNTRY, i);
                    continue;
                }
                if (s.equals("citation")) {
                    this.mapping.put(OccurrencePointFields.CITATION, i);
                    continue;
                }
                if (s.equals("decimalLatitude")) {
                    this.mapping.put(OccurrencePointFields.DECIMAL_LATITUDE, i);
                    continue;
                }
                if (s.equals("decimalLongitude")) {
                    this.mapping.put(OccurrencePointFields.DECIMAL_LONGITUDE, i);
                    continue;
                }
                if (s.equals("coordinateUncertaintyInMeters")) {
                    this.mapping.put(OccurrencePointFields.COORDINATE_UNCERTAINTY_IN_METERS, i);
                    continue;
                }
                if (s.equals("maxDepth")) {
                    this.mapping.put(OccurrencePointFields.MAX_DEPTH, i);
                    continue;
                }
                if (s.equals("minDepth")) {
                    this.mapping.put(OccurrencePointFields.MIN_DEPTH, i);
                    continue;
                }
                if (!s.equals("basisOfRecord")) continue;
                this.mapping.put(OccurrencePointFields.BASIS_OF_RECORD, i);
            }
            if (this.mapping.size() != 21) {
                this.progress.setFailureReason("Unable to understand model");
                this.progress.setFailureDetails("");
                this.progress.setState(StreamProgress.OperationState.FAILED);
            }
        }
    }
}

