/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin;

import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.RepositoryInfo;
import org.gcube.data.spd.model.products.ResultItem;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.obisplugin.ObisClassification;
import org.gcube.data.spd.obisplugin.ObisClient;
import org.gcube.data.spd.obisplugin.ObisNameMapping;
import org.gcube.data.spd.obisplugin.ObisOccurrencesInterface;
import org.gcube.data.spd.obisplugin.PluginSession;
import org.gcube.data.spd.obisplugin.Writer;
import org.gcube.data.spd.obisplugin.data.SearchFilters;
import org.gcube.data.spd.obisplugin.pool.DatabaseCredential;
import org.gcube.data.spd.obisplugin.pool.PluginSessionPool;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.MappingCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ObisPlugin
extends AbstractPlugin {
    protected static final String LOGO_URL = "http://iobis.org/sites/all/themes/corolla/logo.png";
    protected static final String HOME_URL = "http://iobis.org";
    protected static final String DESCRIPTION = "The Ocean Biogeographic information System (OBIS) seeks to absorb, integrate, and assess isolated datasets into a larger, more comprehensive pictures of life in our oceans. The system hopes to stimulate research about our oceans to generate new hypotheses concerning evolutionary processes, species distributions, and roles of organisms in marine systems on a global scale. Created by the Census of Marine Life, OBIS is now part of the Intergovernmental Oceanographic Commission (IOC) of UNESCO, under its International Oceanographic Data and Information Exchange (IODE) programme.";
    protected static final RepositoryInfo REPOSITORY_INFO = new RepositoryInfo("http://iobis.org/sites/all/themes/corolla/logo.png", "http://iobis.org", "The Ocean Biogeographic information System (OBIS) seeks to absorb, integrate, and assess isolated datasets into a larger, more comprehensive pictures of life in our oceans. The system hopes to stimulate research about our oceans to generate new hypotheses concerning evolutionary processes, species distributions, and roles of organisms in marine systems on a global scale. Created by the Census of Marine Life, OBIS is now part of the Intergovernmental Oceanographic Commission (IOC) of UNESCO, under its International Oceanographic Data and Information Exchange (IODE) programme.");
    protected static final String ENTRY_POINT_NAME = "jdbc";
    protected GCUBELog logger = new GCUBELog(ObisPlugin.class);
    protected PluginSessionPool sessionPool;
    protected ObisNameMapping nameMapping;
    protected ObisOccurrencesInterface occurrencesInterface;
    protected ObisClassification obisClassification;
    protected static final SimpleDateFormat sdf = new SimpleDateFormat();

    public PluginSessionPool getSessionPool() {
        return this.sessionPool;
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.NamesMapping);
                this.add(Capabilities.Occurrence);
                this.add(Capabilities.Classification);
            }
        };
    }

    public String getRepositoryName() {
        return "OBIS";
    }

    public String getDescription() {
        return "A plugin for OBIS interaction";
    }

    public void initialize(ServiceEndpoint resource) throws Exception {
        this.setUseCache(true);
        DatabaseCredential databaseCredential = this.getDatabaseCredentials(resource);
        this.sessionPool = new PluginSessionPool(databaseCredential);
        this.nameMapping = new ObisNameMapping(this.sessionPool);
        this.occurrencesInterface = new ObisOccurrencesInterface(this.sessionPool);
        this.obisClassification = new ObisClassification(this.sessionPool);
    }

    public void initialize(DatabaseCredential databaseCredential) throws Exception {
        this.setUseCache(true);
        this.sessionPool = new PluginSessionPool(databaseCredential);
        this.nameMapping = new ObisNameMapping(this.sessionPool);
        this.occurrencesInterface = new ObisOccurrencesInterface(this.sessionPool);
        this.obisClassification = new ObisClassification(this.sessionPool);
    }

    public void shutdown() throws Exception {
        this.sessionPool.shutdown(true);
    }

    public Set<Conditions> getSupportedProperties() {
        return new HashSet<Conditions>(){
            {
                this.add(Conditions.DATE);
                this.add(Conditions.COORDINATE);
            }
        };
    }

    public void update(ServiceEndpoint resource) throws Exception {
        DatabaseCredential databaseCredential = this.getDatabaseCredentials(resource);
        this.sessionPool.setDatabaseCredential(databaseCredential);
    }

    protected DatabaseCredential getDatabaseCredentials(ServiceEndpoint resource) throws Exception {
        ServiceEndpoint.AccessPoint jdbcAccessPoint = null;
        for (ServiceEndpoint.AccessPoint accessPoint : resource.profile().accessPoints()) {
            if (!ENTRY_POINT_NAME.equalsIgnoreCase(accessPoint.name())) continue;
            jdbcAccessPoint = accessPoint;
            break;
        }
        if (jdbcAccessPoint == null) {
            this.logger.error((Object)"AccessPoint with entry name jdbc not found in the plugin RuntimeResource");
            throw new Exception("AccessPoint with entry name jdbc not found in the plugin RuntimeResource");
        }
        String password = StringEncrypter.getEncrypter().decrypt(jdbcAccessPoint.password(), new Key[0]);
        return new DatabaseCredential(jdbcAccessPoint.address(), jdbcAccessPoint.username(), password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String searchTerm, final ObjectWriter<ResultItem> writer, Condition ... properties) {
        this.logger.debug((Object)("starting the search for obisPlugin word: " + searchTerm));
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            final String credits = this.getObisCredits();
            SearchFilters filters = new SearchFilters(properties);
            this.logger.trace((Object)("filters: " + filters));
            ObisClient.searchByScientificName(session, searchTerm, filters, new Writer<ResultItem>(){

                @Override
                public boolean write(ResultItem item) {
                    item.setCredits(credits);
                    writer.write((Object)item);
                    return writer.isAlive();
                }
            });
        }
        catch (Exception e) {
            this.logger.debug((Object)"searchByScientificName failed", (Throwable)e);
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    public MappingCapability getMappingInterface() {
        return this.nameMapping;
    }

    public OccurrencesCapability getOccurrencesInterface() {
        return this.occurrencesInterface;
    }

    protected String getObisCredits() {
        StringBuilder credits = new StringBuilder("Intergovernmental Oceanographic Commission (IOC) of UNESCO. The Ocean Biogeographic Information System. Web. http://www.iobis.org. (Consulted on ");
        credits.append(sdf.format(Calendar.getInstance().getTime()));
        credits.append(")");
        return credits.toString();
    }

    public ClassificationCapability getClassificationInterface() {
        return this.obisClassification;
    }

    public RepositoryInfo getRepositoryInfo() {
        return REPOSITORY_INFO;
    }
}

