/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.search.query;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.gcube.data.spd.obisplugin.search.query.QueryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryByIdentifier {
    private static final Logger log = LoggerFactory.getLogger(QueryByIdentifier.class);
    @NonNull
    private String baseUri;
    @NonNull
    private String key;
    @NonNull
    private QueryType type;
    private List<String> paths = new ArrayList<String>();

    public void addPath(String path) {
        this.paths.add(path);
    }

    public String build() {
        StringBuilder query = new StringBuilder(this.baseUri);
        if (!this.baseUri.endsWith("/")) {
            query.append("/");
        }
        query.append(this.type.getQueryEntry()).append("/");
        query.append(this.key);
        for (String path : this.paths) {
            query.append("/").append(path);
        }
        log.trace("query by dentifier is " + query.toString());
        return query.toString();
    }

    @ConstructorProperties(value={"baseUri", "key", "type"})
    public QueryByIdentifier(@NonNull String baseUri, @NonNull String key, @NonNull QueryType type) {
        if (baseUri == null) {
            throw new NullPointerException("baseUri");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.baseUri = baseUri;
        this.key = key;
        this.type = type;
    }
}

