/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.search;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Coordinate;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.obisplugin.search.ProductKey;
import org.gcube.data.spd.obisplugin.search.query.QueryCondition;

public class Utils {
    protected static List<QueryCondition> elaborateConditions(Condition[] properties) throws Exception {
        ArrayList<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        ArrayList<Condition> coordinateConditions = new ArrayList<Condition>();
        block4: for (Condition prop : properties) {
            switch (prop.getType()) {
                case COORDINATE: {
                    coordinateConditions.add(prop);
                    continue block4;
                }
                case DATE: {
                    Calendar date = (Calendar)prop.getValue();
                    queryConditions.addAll(Utils.getDateCondition(date, prop));
                }
            }
        }
        if (coordinateConditions.size() > 0) {
            queryConditions.add(Utils.getCoordinateConditions(coordinateConditions));
        }
        return queryConditions;
    }

    public static ProductKey elaborateProductsKey(String id) {
        ArrayList<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        String[] splitString = id.split("\\|\\|");
        queryConditions.add(QueryCondition.cond("resourceid", splitString[0]));
        queryConditions.add(QueryCondition.cond("obisid", splitString[1]));
        if (splitString.length > 2) {
            for (int i = 2; i < splitString.length; ++i) {
                String[] equalSplit = splitString[i].split("=");
                queryConditions.add(QueryCondition.cond(equalSplit[0], equalSplit[1].replaceAll(" ", "%20")));
            }
        }
        return new ProductKey(queryConditions);
    }

    protected static String createProductsKey(String dataResourceKey, String taxonKey, List<QueryCondition> queryConditions) {
        StringBuilder conditionTransformer = new StringBuilder();
        for (QueryCondition cond : queryConditions) {
            conditionTransformer.append("||").append(cond.getKey()).append("=").append(cond.getValue());
        }
        return dataResourceKey + "||" + taxonKey + conditionTransformer.toString();
    }

    public static QueryCondition getCoordinateConditions(List<Condition> coordinateConditions) {
        double lowerLong = -180.0;
        double lowerLat = -90.0;
        double upperLat = 90.0;
        double upperLong = 180.0;
        for (Condition cond : coordinateConditions) {
            switch (cond.getOp()) {
                case EQ: {
                    break;
                }
                case GT: {
                    double latitude = ((Coordinate)cond.getValue()).getLatitude() + 0.01;
                    double longitude = ((Coordinate)cond.getValue()).getLongitude() + 0.01;
                    if (latitude > lowerLat) {
                        lowerLat = latitude;
                    }
                    if (!(longitude > lowerLong)) break;
                    lowerLong = longitude;
                    break;
                }
                case GE: {
                    double latitude = ((Coordinate)cond.getValue()).getLatitude();
                    double longitude = ((Coordinate)cond.getValue()).getLongitude();
                    if (latitude > lowerLat) {
                        lowerLat = latitude;
                    }
                    if (!(longitude > lowerLong)) break;
                    lowerLong = longitude;
                    break;
                }
                case LT: {
                    double latitude = ((Coordinate)cond.getValue()).getLatitude() - 0.01;
                    double longitude = ((Coordinate)cond.getValue()).getLongitude() - 0.01;
                    if (latitude < upperLat) {
                        upperLat = latitude;
                    }
                    if (!(longitude > upperLong)) break;
                    upperLong = longitude;
                    break;
                }
                case LE: {
                    double latitude = ((Coordinate)cond.getValue()).getLatitude();
                    double longitude = ((Coordinate)cond.getValue()).getLongitude();
                    if (latitude < upperLat) {
                        upperLat = latitude;
                    }
                    if (!(longitude > upperLong)) break;
                    upperLong = longitude;
                    break;
                }
            }
        }
        return QueryCondition.cond("geometry", String.format("POLYGON((%1$f %2$f,%3$f %4$f,%5$f %6$f,%1$f %2$f))", lowerLat, lowerLong, upperLat, lowerLong, upperLat, upperLong, lowerLat, upperLong).replaceAll(" ", "%20"));
    }

    public static List<QueryCondition> getDateCondition(Calendar date, Condition prop) {
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar newDate = date;
        switch (prop.getOp()) {
            case EQ: {
                conditions.add(QueryCondition.cond("eventDate", dateFormat.format(date.getTime())));
                break;
            }
            case GT: {
                newDate.add(5, 1);
                conditions.add(QueryCondition.cond("startdate", dateFormat.format(newDate.getTime())));
                break;
            }
            case GE: {
                conditions.add(QueryCondition.cond("startdate", dateFormat.format(date.getTime())));
                break;
            }
            case LT: {
                newDate.add(5, -1);
                conditions.add(QueryCondition.cond("enddate", dateFormat.format(newDate.getTime())));
                break;
            }
            case LE: {
                conditions.add(QueryCondition.cond("enddate", dateFormat.format(date.getTime())));
                break;
            }
        }
        return conditions;
    }

    protected static String getDataSetAsString(DataSet dataset) {
        return dataset.getId();
    }
}

