/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.specieslink;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.model.BasisOfRecord;
import org.gcube.data.spd.model.OccurrencePoint;
import org.gcube.data.spd.model.Properties;
import org.gcube.data.spd.model.Property;
import org.gcube.data.spd.model.exceptions.StreamBlockingException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.parser.DarwinRecord;
import org.gcube.data.spd.parser.RecordsIterator;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.gcube.data.spd.specieslink.SpeciesLinkPlugin;
import org.gcube.data.spd.specieslink.Utils;

public class OccurrencesCapabilityImpl
extends OccurrencesCapability {
    GCUBELog logger = new GCUBELog(OccurrencesCapabilityImpl.class);

    public Set<Properties> getSupportedProperties() {
        return new HashSet<Properties>(){
            {
                this.add(Properties.DateFrom);
                this.add(Properties.DateTo);
                this.add(Properties.CoordinateFrom);
                this.add(Properties.CoordinateTo);
            }
        };
    }

    private static BasisOfRecord matchBasisOfRecord(String value) {
        for (BasisOfRecord record : BasisOfRecord.values()) {
            if (!record.name().toLowerCase().equals(value.toLowerCase())) continue;
            return record;
        }
        if (value.toLowerCase().equals("S".toLowerCase())) {
            return BasisOfRecord.PreservedSpecimen;
        }
        if (value.toLowerCase().equals("Fotot".toLowerCase())) {
            return BasisOfRecord.MachineObservation;
        }
        return BasisOfRecord.HumanObservation;
    }

    public void searchByCommonName(String word, ObjectWriter<OccurrencePoint> writer, Property ... properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String scientificName, ObjectWriter<OccurrencePoint> writer, Property ... properties) {
        this.logger.trace((Object)("searchByScientificName " + scientificName + " in SpeciesLink"));
        String f = "";
        try {
            f = Utils.elaborateProps(properties);
        }
        catch (Exception e) {
            this.logger.error((Object)"error elaborating properties", (Throwable)e);
            writer.close();
            return;
        }
        String filter = "http://rs.tdwg.org/dwc/dwcore/ScientificName%20like%20%22" + scientificName.replace(" ", "%20") + "%22" + f + "&orderBy=http://rs.tdwg.org/dwc/dwcore/ScientificName&orderBy=http://rs.tdwg.org/dwc/dwcore/InstitutionCode";
        RecordsIterator set = new RecordsIterator(SpeciesLinkPlugin.baseurl, filter, SpeciesLinkPlugin.model);
        RecordsIterator it = set.iterator();
        DarwinRecord element = null;
        try {
            while (it.hasNext()) {
                element = (DarwinRecord)it.next();
                OccurrencePoint a = new OccurrencePoint(element.globalUniqueIdentifier + "");
                a.setBasisOfRecord(OccurrencesCapabilityImpl.matchBasisOfRecord(element.basisOfRecord));
                a.setCatalogueNumber(element.catalogNumber);
                a.setCitation(element.identifiedBy);
                a.setCollectionCode(element.collectionCode);
                a.setCountry(element.country);
                a.setDecimalLatitude(element.decimalLatitude);
                a.setDecimalLongitude(element.decimalLongitude);
                a.setEventDate(null);
                a.setFamily(element.family);
                a.setInstitutionCode(element.institutionCode);
                a.setKingdom(element.kingdom);
                a.setLocality(element.country);
                a.setMaxDepth((double)element.maximumDepthInMeters);
                a.setMinDepth((double)element.minimumDepthInMeters);
                a.setModified(element.dateLastModified);
                a.setRecordedBy(element.identifiedBy);
                a.setScientificName(element.scientificName);
                a.setCredits(Utils.credits());
                a.setCitation(Utils.citation());
                if (a != null && writer.isAlive()) {
                    writer.write((Object)a);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"General Error", (Throwable)e);
            writer.write((StreamException)new StreamBlockingException());
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOccurrencesByIds(ObjectWriter<OccurrencePoint> writer, Iterator<String> ids) {
        try {
            block5: while (ids.hasNext()) {
                String id = ids.next();
                this.logger.trace((Object)("getOccurrencesByIds " + id + " in SpeciesLink"));
                String filter = "http://rs.tdwg.org/dwc/dwcore/GlobalUniqueIdentifier%20equals%20%22" + id + "%22";
                RecordsIterator set = new RecordsIterator(SpeciesLinkPlugin.baseurl, filter, SpeciesLinkPlugin.model);
                RecordsIterator it = set.iterator();
                DarwinRecord element = null;
                while (it.hasNext()) {
                    element = (DarwinRecord)it.next();
                    OccurrencePoint a = new OccurrencePoint(id);
                    a.setBasisOfRecord(OccurrencesCapabilityImpl.matchBasisOfRecord(element.basisOfRecord));
                    a.setCatalogueNumber(element.catalogNumber);
                    a.setCitation(element.identifiedBy);
                    a.setCollectionCode(element.collectionCode);
                    a.setCountry(element.country);
                    a.setDecimalLatitude(element.decimalLatitude);
                    a.setDecimalLongitude(element.decimalLongitude);
                    a.setEventDate(null);
                    a.setFamily(element.family);
                    a.setInstitutionCode(element.institutionCode);
                    a.setKingdom(element.kingdom);
                    a.setLocality(element.country);
                    a.setMaxDepth((double)element.maximumDepthInMeters);
                    a.setMinDepth((double)element.minimumDepthInMeters);
                    a.setModified(element.dateLastModified);
                    a.setRecordedBy(element.identifiedBy);
                    a.setScientificName(element.scientificName);
                    a.setCredits(Utils.credits());
                    a.setCitation(Utils.citation());
                    if (a == null || !writer.isAlive()) continue block5;
                    writer.write((Object)a);
                }
            }
        }
        catch (Exception e) {
            writer.write((StreamException)new StreamBlockingException());
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOccurrencesByProductKeys(ObjectWriter<OccurrencePoint> writer, Iterator<String> keys) {
        try {
            block5: while (keys.hasNext()) {
                String key = keys.next();
                this.logger.trace((Object)("getOccurrencesByProductKeys " + key + " in SpeciesLink"));
                RecordsIterator set = new RecordsIterator(SpeciesLinkPlugin.baseurl, key, SpeciesLinkPlugin.model);
                RecordsIterator it = set.iterator();
                DarwinRecord element = null;
                while (it.hasNext()) {
                    element = (DarwinRecord)it.next();
                    OccurrencePoint a = new OccurrencePoint(element.globalUniqueIdentifier + "");
                    a.setBasisOfRecord(OccurrencesCapabilityImpl.matchBasisOfRecord(element.basisOfRecord));
                    a.setCatalogueNumber(element.catalogNumber);
                    a.setCitation(element.identifiedBy);
                    a.setCollectionCode(element.collectionCode);
                    a.setCountry(element.country);
                    a.setDecimalLatitude(element.decimalLatitude);
                    a.setDecimalLongitude(element.decimalLongitude);
                    a.setEventDate(null);
                    a.setFamily(element.family);
                    a.setInstitutionCode(element.institutionCode);
                    a.setKingdom(element.kingdom);
                    a.setLocality(element.country);
                    a.setMaxDepth((double)element.maximumDepthInMeters);
                    a.setMinDepth((double)element.minimumDepthInMeters);
                    a.setModified(element.dateLastModified);
                    a.setRecordedBy(element.identifiedBy);
                    a.setScientificName(element.scientificName);
                    a.setCredits(Utils.credits());
                    a.setCitation(Utils.citation());
                    if (a == null || !writer.isAlive()) continue block5;
                    writer.write((Object)a);
                }
            }
        }
        catch (Exception e) {
            writer.write((StreamException)new StreamBlockingException());
        }
        finally {
            writer.close();
        }
    }
}

