/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.specieslink;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.data.spd.model.DataProvider;
import org.gcube.data.spd.model.DataSet;
import org.gcube.data.spd.model.Product;
import org.gcube.data.spd.model.Property;
import org.gcube.data.spd.model.ResultItem;
import org.gcube.data.spd.model.Taxon;
import org.gcube.data.spd.model.exceptions.StreamBlockingException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.parser.DarwinRecord;
import org.gcube.data.spd.parser.RecordsIterator;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.SearchTypes;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.util.RepositoryInfo;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.gcube.data.spd.specieslink.OccurrencesCapabilityImpl;
import org.gcube.data.spd.specieslink.Utils;

public class SpeciesLinkPlugin
extends AbstractPlugin {
    GCUBELog logger = new GCUBELog(SpeciesLinkPlugin.class);
    public static String baseurl;
    public static String model;
    public static final String credits = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with speciesLink (http://splink.cria.org.br/)";
    public static final String citation = "Accessed through: speciesLink at http://splink.cria.org.br/ on XDATEX";

    public void initialize(ServiceEndpoint res) throws Exception {
        this.setUseCache(true);
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (!ap.name().equals("tapir")) continue;
            baseurl = ap.address();
            for (Object p : ap.properties()) {
                if (!p.equals("model")) continue;
                model = p.toString();
            }
        }
        this.logger.trace((Object)"SpeciesPlugin initialized");
        super.initialize(res);
    }

    public void update(ServiceEndpoint res) throws Exception {
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (!ap.name().equals("tapir")) continue;
            baseurl = ap.address();
            for (Object p : ap.properties()) {
                if (!p.equals("model")) continue;
                model = p.toString();
            }
        }
        this.logger.trace((Object)"SpeciesPlugin updated");
        super.update(res);
    }

    public String getDescription() {
        return "Species Link Plugin";
    }

    public String getRepositoryName() {
        return "SpeciesLink";
    }

    public Set<SearchTypes> getSupportedSearch() {
        return Collections.singleton(SearchTypes.ScientificName);
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.Occurences);
            }
        };
    }

    public OccurrencesCapability getOccurrencesInterface() {
        return new OccurrencesCapabilityImpl();
    }

    public void searchByCommonName(String arg0, ObjectWriter<ResultItem> arg1, Property ... arg2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchByScientificName(String scientificName, ObjectWriter<ResultItem> writer, Property ... p) {
        String f = "";
        try {
            f = Utils.elaborateProps(p);
        }
        catch (Exception e) {
            this.logger.error((Object)"error elaborating properties", (Throwable)e);
            writer.close();
            return;
        }
        String filter = "http://rs.tdwg.org/dwc/dwcore/ScientificName%20like%20%22" + scientificName.replace(" ", "%20") + "%22" + f + "&orderBy=http://rs.tdwg.org/dwc/dwcore/ScientificName&orderBy=http://rs.tdwg.org/dwc/dwcore/InstitutionCode";
        int count = 0;
        boolean flag = false;
        DarwinRecord element = null;
        DarwinRecord element1 = null;
        try {
            RecordsIterator set = new RecordsIterator(baseurl, filter, model);
            RecordsIterator it = set.iterator();
            while (it.hasNext()) {
                flag = true;
                element = (DarwinRecord)it.next();
                if (element1 == null) {
                    element1 = element;
                }
                if (element1.institutionCode.toLowerCase().equals(element.institutionCode.toLowerCase()) & element1.scientificName.toLowerCase().equals(element.scientificName.toLowerCase())) {
                    ++count;
                    continue;
                }
                if (this.setResult(element1, count, writer)) {
                    element1 = element;
                    count = 1;
                    continue;
                }
                flag = false;
                break;
            }
            if (flag) {
                this.setResult(element1, count, writer);
            }
        }
        catch (Exception e) {
            writer.write((StreamException)new StreamBlockingException());
        }
        finally {
            writer.close();
        }
    }

    private boolean setResult(DarwinRecord element, int count, ObjectWriter<ResultItem> writer) {
        try {
            ResultItem rs = new ResultItem(Integer.toString(element.globalUniqueIdentifier), element.scientificName);
            rs.setAuthor(element.authorYearOfScientificName);
            rs.setCitation(element.remarks);
            rs.setCitation(element.collector);
            Calendar now = Calendar.getInstance();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            rs.setCredits(credits.replace("XDATEX", format.format(now.getTime())));
            rs.setCitation(citation.replace("XDATEX", format.format(now.getTime())));
            DataSet dataSet = new DataSet(element.collectionCode);
            dataSet.setName(element.collectionCode);
            rs.setDataSet(dataSet);
            DataProvider dp = new DataProvider(element.institutionCode);
            dp.setName(element.institutionCode);
            dataSet.setDataProvider(dp);
            Product prod = new Product(Capabilities.Occurences, "http://rs.tdwg.org/dwc/dwcore/ScientificName%20equals%20%22" + element.scientificName.replace(" ", "%20") + "%22%20and%20http://rs.tdwg.org/dwc/dwcore/CollectionCode%20equals%20%22" + element.collectionCode + "%22");
            prod.setCount(count);
            rs.setProducts(Collections.singletonList(prod));
            Taxon last = null;
            if (element.kingdom != "") {
                if (element.kingdom.equals(element.scientificName)) {
                    rs.setRank("kingdom");
                } else {
                    Taxon k = new Taxon(element.kingdom);
                    k.setRank("kingdom");
                    k.setScientificName(element.kingdom);
                    last = k;
                }
            }
            if (element.phylum != "") {
                if (element.phylum.equals(element.scientificName)) {
                    rs.setRank("phylum");
                } else {
                    Taxon p = new Taxon(element.phylum);
                    p.setRank("phylum");
                    p.setScientificName(element.phylum);
                    if (last != null) {
                        p.setParent(last);
                    }
                    last = p;
                }
            }
            if (element.clazz != "") {
                if (element.clazz.equals(element.scientificName)) {
                    rs.setRank("class");
                } else {
                    Taxon c = new Taxon(element.clazz);
                    c.setRank("class");
                    c.setScientificName(element.clazz);
                    if (last != null) {
                        c.setParent(last);
                    }
                    last = c;
                }
            }
            if (element.order != "") {
                if (element.order.equals(element.scientificName)) {
                    rs.setRank("order");
                } else {
                    Taxon o = new Taxon(element.order);
                    o.setRank("order");
                    o.setScientificName(element.order);
                    if (last != null) {
                        o.setParent(last);
                    }
                    last = o;
                }
            }
            if (element.family != "") {
                if (element.family.equals(element.scientificName)) {
                    rs.setRank("family");
                } else {
                    Taxon f = new Taxon(element.family);
                    f.setRank("family");
                    f.setScientificName(element.family);
                    if (last != null) {
                        f.setParent(last);
                    }
                    last = f;
                }
            }
            if (element.genus != "") {
                if (element.genus.equals(element.scientificName)) {
                    rs.setRank("genus");
                } else {
                    Taxon g = new Taxon(element.genus);
                    g.setRank("genus");
                    g.setScientificName(element.genus);
                    if (last != null) {
                        g.setParent(last);
                    }
                    last = g;
                }
            }
            if (rs.getRank() == null) {
                rs.setRank("species");
            }
            if (last != null) {
                rs.setParent(last);
            }
            rs.setCredits(Utils.credits());
            rs.setCitation(Utils.citation());
            if (writer.isAlive()) {
                writer.write((Object)rs);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public RepositoryInfo getRepositoryInfo() {
        RepositoryInfo info = new RepositoryInfo("http://splink.cria.org.br/images/logo_peq.gif", "http://splink.cria.org.br/", "The goal of the speciesLink network is to integrate specie and specimen data available in natural history museums, herbaria and culture collections, making it openly and freely available on the Internet.");
        return info;
    }
}

