/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.specieslink;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.RepositoryInfo;
import org.gcube.data.spd.model.exceptions.StreamBlockingException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.model.products.DataProvider;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.model.products.Product;
import org.gcube.data.spd.model.products.ResultItem;
import org.gcube.data.spd.model.products.Taxon;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.parser.DarwinSimpleRecord;
import org.gcube.data.spd.parser.RecordsIterator;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.gcube.data.spd.specieslink.OccurrencesCapabilityImpl;
import org.gcube.data.spd.specieslink.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeciesLinkPlugin
extends AbstractPlugin {
    static Logger logger = LoggerFactory.getLogger(SpeciesLinkPlugin.class);
    public static String baseurl;
    public static String model;
    public static int limit;
    public static final String credits = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with speciesLink (http://splink.cria.org.br/)";
    public static final String citation = "Accessed through: speciesLink at http://splink.cria.org.br/ on XDATEX";

    public void initialize(ServiceEndpoint res) throws Exception {
        logger.trace("SpeciesPlugin starting initialization");
        this.setUseCache(true);
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (!ap.name().equals("tapir")) continue;
            baseurl = ap.address();
            for (ServiceEndpoint.Property p : ap.properties()) {
                if (p.name().equals("model")) {
                    model = p.value();
                    continue;
                }
                if (!p.name().equals("limit")) continue;
                limit = Integer.parseInt(p.value());
            }
        }
        logger.trace("SpeciesPlugin initialized");
        super.initialize(res);
    }

    public void update(ServiceEndpoint res) throws Exception {
        for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
            if (!ap.name().equals("tapir")) continue;
            baseurl = ap.address();
            for (ServiceEndpoint.Property p : ap.properties()) {
                if (p.name().equals("model")) {
                    model = p.value();
                    continue;
                }
                if (!p.name().equals("limit")) continue;
                limit = Integer.parseInt(p.value());
            }
        }
        logger.trace("SpeciesPlugin updated");
        super.update(res);
    }

    public String getDescription() {
        return "Species Link Plugin";
    }

    public String getRepositoryName() {
        return "SpeciesLink";
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.Occurrence);
            }
        };
    }

    public OccurrencesCapability getOccurrencesInterface() {
        return new OccurrencesCapabilityImpl();
    }

    public void searchByScientificName(String scientificName, ObjectWriter<ResultItem> writer, Condition ... properties) {
        logger.trace("searchByScientificName");
        String f = "";
        try {
            f = Utils.elaborateProps(properties);
        }
        catch (Exception e) {
            logger.error("error elaborating properties", (Throwable)e);
            return;
        }
        String filter = "http://rs.tdwg.org/dwc/dwcore/ScientificName%20like%20%22" + scientificName.replace(" ", "%20") + "%22" + f + "&orderBy=http://rs.tdwg.org/dwc/dwcore/ScientificName&orderBy=http://rs.tdwg.org/dwc/dwcore/InstitutionCode";
        int count = 0;
        boolean flag = false;
        DarwinSimpleRecord element = null;
        DarwinSimpleRecord element1 = null;
        try {
            RecordsIterator set = new RecordsIterator(baseurl, filter, model, limit, false);
            RecordsIterator it = set.iterator();
            while (it.hasNext()) {
                flag = true;
                element = (DarwinSimpleRecord)it.next();
                if (element1 == null) {
                    element1 = element;
                }
                if (element1.institutionCode.toLowerCase().equals(element.institutionCode.toLowerCase()) & element1.scientificName.toLowerCase().equals(element.scientificName.toLowerCase())) {
                    ++count;
                    continue;
                }
                if (this.setResult(element1, count, writer)) {
                    element1 = element;
                    count = 1;
                    continue;
                }
                flag = false;
                break;
            }
            if (flag) {
                this.setResult(element1, count, writer);
            }
        }
        catch (Exception e) {
            writer.write((StreamException)new StreamBlockingException("SpeciesLink", ""));
        }
    }

    private boolean setResult(DarwinSimpleRecord element, int count, ObjectWriter<ResultItem> writer) {
        try {
            String scientificName = element.scientificName;
            String collectionCode = element.collectionCode;
            String institutionCode = element.institutionCode;
            ResultItem rs = new ResultItem(element.globalUniqueIdentifier, scientificName);
            rs.setScientificNameAuthorship(element.authorYearOfScientificName);
            rs.setCredits(Utils.credits());
            rs.setCitation(Utils.citation());
            DataSet dataSet = new DataSet(collectionCode);
            dataSet.setName(collectionCode);
            rs.setDataSet(dataSet);
            DataProvider dp = new DataProvider(institutionCode);
            dp.setName(institutionCode);
            dataSet.setDataProvider(dp);
            String key = "http://rs.tdwg.org/dwc/dwcore/ScientificName%20equals%20%22" + scientificName.replace(" ", "%20") + "%22%20and%20http://rs.tdwg.org/dwc/dwcore/CollectionCode%20equals%20%22" + collectionCode + "%22";
            Product prod = new Product(Product.ProductType.Occurrence, key);
            prod.setCount(count);
            rs.setProducts(Collections.singletonList(prod));
            Taxon last = null;
            String kingdom = null;
            kingdom = element.kingdom;
            if (kingdom != null) {
                if (kingdom.equals(scientificName)) {
                    rs.setRank("kingdom");
                } else {
                    Taxon k = new Taxon(kingdom);
                    k.setRank("kingdom");
                    k.setScientificName(kingdom);
                    last = k;
                }
            }
            String phylum = null;
            phylum = element.phylum;
            if (phylum != null) {
                if (phylum.equals(scientificName)) {
                    rs.setRank("phylum");
                } else {
                    Taxon p = new Taxon(phylum);
                    p.setRank("phylum");
                    p.setScientificName(phylum);
                    if (last != null) {
                        p.setParent(last);
                    }
                    last = p;
                }
            }
            String clazz = null;
            clazz = element.clazz;
            if (clazz != null) {
                if (clazz.equals(scientificName)) {
                    rs.setRank("class");
                } else {
                    Taxon c = new Taxon(clazz);
                    c.setRank("class");
                    c.setScientificName(clazz);
                    if (last != null) {
                        c.setParent(last);
                    }
                    last = c;
                }
            }
            String order = null;
            order = element.order;
            if (order != null) {
                if (order.equals(scientificName)) {
                    rs.setRank("order");
                } else {
                    Taxon o = new Taxon(order);
                    o.setRank("order");
                    o.setScientificName(order);
                    if (last != null) {
                        o.setParent(last);
                    }
                    last = o;
                }
            }
            String family = null;
            family = element.family;
            if (family != null) {
                if (family.equals(scientificName)) {
                    rs.setRank("family");
                } else {
                    Taxon f = new Taxon(family);
                    f.setRank("family");
                    f.setScientificName(family);
                    if (last != null) {
                        f.setParent(last);
                    }
                    last = f;
                }
            }
            if (element.genus != null) {
                if (element.genus.equals(scientificName)) {
                    rs.setRank("genus");
                } else {
                    Taxon g = new Taxon(element.genus);
                    g.setRank("genus");
                    g.setScientificName(element.genus);
                    if (last != null) {
                        g.setParent(last);
                    }
                    last = g;
                }
            }
            if (rs.getRank() == null) {
                rs.setRank("species");
            }
            if (last != null) {
                rs.setParent(last);
            }
            if (writer.isAlive()) {
                writer.write((Object)rs);
            }
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
            return false;
        }
        return true;
    }

    public RepositoryInfo getRepositoryInfo() {
        RepositoryInfo info = new RepositoryInfo("http://splink.cria.org.br/images/logo_peq.gif", "http://splink.cria.org.br/", "The goal of the speciesLink network is to integrate specie and specimen data available in natural history museums, herbaria and culture collections, making it openly and freely available on the Internet.");
        return info;
    }
}

