/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tr.neo;

import org.gcube.data.streams.delegates.StreamListener;
import org.gcube.data.streams.generators.Generator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactingGenerator<FROM, TO>
implements Generator<FROM, TO>,
StreamListener {
    private static Logger log = LoggerFactory.getLogger(TransactingGenerator.class);
    private static final int BATCH_TRANSACTION_SIZE = 2;
    final GraphDatabaseService db;
    final Generator<FROM, TO> generator;
    final String name;
    private long count = 0L;
    Transaction transaction;

    public TransactingGenerator(GraphDatabaseService db, Generator<FROM, TO> filter, String name) {
        this.generator = filter;
        this.db = db;
        this.name = name;
    }

    public void onStart() {
        log.trace("starting transaction " + this.name);
        this.transaction = this.db.beginTx();
    }

    public TO yield(FROM element) {
        Object result = this.generator.yield(element);
        ++this.count;
        if (this.count % 2L == 0L) {
            this.transaction.success();
            this.transaction.finish();
            this.transaction = this.db.beginTx();
        }
        return (TO)result;
    }

    public void onEnd() {
        log.trace("closing transaction " + this.name);
        if (this.transaction != null) {
            this.transaction.success();
            this.transaction.finish();
        }
    }

    public void onClose() {
    }
}

