/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.common.messaging.messages;

import java.util.ArrayList;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.common.messaging.messages.MessageLabels;
import org.gcube.datatransfer.common.messaging.utils.Utils;
import org.gcube.datatransfer.common.outcome.FileTransferOutcome;
import org.gcube.datatransfer.common.outcome.TreeTransferOutcome;

public class TransferResponseMessage
extends GCUBEMessage {
    private static final long serialVersionUID = 1L;
    public static final MessageLabels messageType = MessageLabels.DataTransferResponse;
    private String sourceEndpoint;
    private String destEndpoint;
    private String transferId;
    private String transferStatus;
    private Types.MonitorTransferReportMessage monitorResponse;
    private ArrayList<FileTransferOutcome> outcomesResponse;
    private TreeTransferOutcome treeOutcomeResponse;
    public static final String dataTransferLabel = MessageLabels.DataTransferResponse.toString();

    public void createTopicName(GCUBEScope scope) {
        if (scope.isInfrastructure()) {
            this.topic = Utils.replaceUnderscore(scope.getName()) + "." + dataTransferLabel + "." + Utils.replaceUnderscore(this.sourceEndpoint);
        } else if (scope.getType().compareTo((Enum)GCUBEScope.Type.VO) == 0) {
            String voName = scope.getName();
            this.topic = Utils.replaceUnderscore(scope.getInfrastructure().getName()) + "." + Utils.replaceUnderscore(voName) + "." + dataTransferLabel + "." + Utils.replaceUnderscore(this.sourceEndpoint);
        }
    }

    public String getSourceEndpoint() {
        return this.sourceEndpoint;
    }

    public String getDestEndpoint() {
        return this.destEndpoint;
    }

    public String getTransferId() {
        return this.transferId;
    }

    public Types.MonitorTransferReportMessage getMonitorResponse() {
        return this.monitorResponse;
    }

    public ArrayList<FileTransferOutcome> getOutcomesResponse() {
        return this.outcomesResponse;
    }

    public void setSourceEndpoint(String sourceEndpoint) {
        this.sourceEndpoint = sourceEndpoint;
    }

    public void setDestEndpoint(String destEndpoint) {
        this.destEndpoint = destEndpoint;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public void setMonitorResponse(Types.MonitorTransferReportMessage monitorResponse) {
        this.monitorResponse = monitorResponse;
    }

    public void setOutcomesResponse(ArrayList<FileTransferOutcome> outcomesResponse) {
        this.outcomesResponse = outcomesResponse;
    }

    public String getTransferStatus() {
        return this.transferStatus;
    }

    public void setTransferStatus(String transferStatus) {
        this.transferStatus = transferStatus;
    }

    public TreeTransferOutcome getTreeOutcomeResponse() {
        return this.treeOutcomeResponse;
    }

    public void setTreeOutcomeResponse(TreeTransferOutcome treeOutcomeResponse) {
        this.treeOutcomeResponse = treeOutcomeResponse;
    }
}

