/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.library;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.gcube.data.transfer.library.model.Source;

public class TransferResult {
    @NonNull
    private Source source;
    @NonNull
    private String destinationHostName;
    @NonNull
    private Long elapsedTime;
    @NonNull
    private Long transferedBytes;
    @NonNull
    private String remotePath;

    @ConstructorProperties(value={"source", "destinationHostName", "elapsedTime", "transferedBytes", "remotePath"})
    public TransferResult(@NonNull Source source, @NonNull String destinationHostName, @NonNull Long elapsedTime, @NonNull Long transferedBytes, @NonNull String remotePath) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (destinationHostName == null) {
            throw new NullPointerException("destinationHostName");
        }
        if (elapsedTime == null) {
            throw new NullPointerException("elapsedTime");
        }
        if (transferedBytes == null) {
            throw new NullPointerException("transferedBytes");
        }
        if (remotePath == null) {
            throw new NullPointerException("remotePath");
        }
        this.source = source;
        this.destinationHostName = destinationHostName;
        this.elapsedTime = elapsedTime;
        this.transferedBytes = transferedBytes;
        this.remotePath = remotePath;
    }

    @NonNull
    public Source getSource() {
        return this.source;
    }

    @NonNull
    public String getDestinationHostName() {
        return this.destinationHostName;
    }

    @NonNull
    public Long getElapsedTime() {
        return this.elapsedTime;
    }

    @NonNull
    public Long getTransferedBytes() {
        return this.transferedBytes;
    }

    @NonNull
    public String getRemotePath() {
        return this.remotePath;
    }

    public void setSource(@NonNull Source source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        this.source = source;
    }

    public void setDestinationHostName(@NonNull String destinationHostName) {
        if (destinationHostName == null) {
            throw new NullPointerException("destinationHostName");
        }
        this.destinationHostName = destinationHostName;
    }

    public void setElapsedTime(@NonNull Long elapsedTime) {
        if (elapsedTime == null) {
            throw new NullPointerException("elapsedTime");
        }
        this.elapsedTime = elapsedTime;
    }

    public void setTransferedBytes(@NonNull Long transferedBytes) {
        if (transferedBytes == null) {
            throw new NullPointerException("transferedBytes");
        }
        this.transferedBytes = transferedBytes;
    }

    public void setRemotePath(@NonNull String remotePath) {
        if (remotePath == null) {
            throw new NullPointerException("remotePath");
        }
        this.remotePath = remotePath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferResult)) {
            return false;
        }
        TransferResult other = (TransferResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Source this$source = this.getSource();
        Source other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        String this$destinationHostName = this.getDestinationHostName();
        String other$destinationHostName = other.getDestinationHostName();
        if (this$destinationHostName == null ? other$destinationHostName != null : !this$destinationHostName.equals(other$destinationHostName)) {
            return false;
        }
        Long this$elapsedTime = this.getElapsedTime();
        Long other$elapsedTime = other.getElapsedTime();
        if (this$elapsedTime == null ? other$elapsedTime != null : !((Object)this$elapsedTime).equals(other$elapsedTime)) {
            return false;
        }
        Long this$transferedBytes = this.getTransferedBytes();
        Long other$transferedBytes = other.getTransferedBytes();
        if (this$transferedBytes == null ? other$transferedBytes != null : !((Object)this$transferedBytes).equals(other$transferedBytes)) {
            return false;
        }
        String this$remotePath = this.getRemotePath();
        String other$remotePath = other.getRemotePath();
        return !(this$remotePath == null ? other$remotePath != null : !this$remotePath.equals(other$remotePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransferResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Source $source = this.getSource();
        result = result * 59 + ($source == null ? 0 : ((Object)$source).hashCode());
        String $destinationHostName = this.getDestinationHostName();
        result = result * 59 + ($destinationHostName == null ? 0 : $destinationHostName.hashCode());
        Long $elapsedTime = this.getElapsedTime();
        result = result * 59 + ($elapsedTime == null ? 0 : ((Object)$elapsedTime).hashCode());
        Long $transferedBytes = this.getTransferedBytes();
        result = result * 59 + ($transferedBytes == null ? 0 : ((Object)$transferedBytes).hashCode());
        String $remotePath = this.getRemotePath();
        result = result * 59 + ($remotePath == null ? 0 : $remotePath.hashCode());
        return result;
    }

    public String toString() {
        return "TransferResult(source=" + this.getSource() + ", destinationHostName=" + this.getDestinationHostName() + ", elapsedTime=" + this.getElapsedTime() + ", transferedBytes=" + this.getTransferedBytes() + ", remotePath=" + this.getRemotePath() + ")";
    }
}

